% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_delete_comment_content}
\alias{codecommit_delete_comment_content}
\title{Deletes the content of a comment made on a change, file, or commit in a
repository}
\usage{
codecommit_delete_comment_content(commentId)
}
\arguments{
\item{commentId}{[required] The unique, system-generated ID of the comment. To get this ID, use
\code{\link[=codecommit_get_comments_for_compared_commit]{get_comments_for_compared_commit}}
or
\code{\link[=codecommit_get_comments_for_pull_request]{get_comments_for_pull_request}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  comment = list(
    commentId = "string",
    content = "string",
    inReplyTo = "string",
    creationDate = as.POSIXct(
      "2015-01-01"
    ),
    lastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    authorArn = "string",
    deleted = TRUE|FALSE,
    clientRequestToken = "string",
    callerReactions = list(
      "string"
    ),
    reactionCounts = list(
      123
    )
  )
)
}
}
\description{
Deletes the content of a comment made on a change, file, or commit in a
repository.
}
\section{Request syntax}{
\preformatted{svc$delete_comment_content(
  commentId = "string"
)
}
}

\keyword{internal}
