% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_switchover_global_cluster}
\alias{docdb_switchover_global_cluster}
\title{Switches over the specified secondary Amazon DocumentDB cluster to be
the new primary Amazon DocumentDB cluster in the global database cluster}
\usage{
docdb_switchover_global_cluster(
  GlobalClusterIdentifier,
  TargetDbClusterIdentifier
)
}
\arguments{
\item{GlobalClusterIdentifier}{[required] The identifier of the Amazon DocumentDB global database cluster to
switch over. The identifier is the unique key assigned by the user when
the cluster is created. In other words, it's the name of the global
cluster. This parameter isn’t case-sensitive.

Constraints:
\itemize{
\item Must match the identifier of an existing global cluster (Amazon
DocumentDB global database).
\item Minimum length of 1. Maximum length of 255.
}

Pattern: \verb{[A-Za-z][0-9A-Za-z-:._]*}}

\item{TargetDbClusterIdentifier}{[required] The identifier of the secondary Amazon DocumentDB cluster to promote to
the new primary for the global database cluster. Use the Amazon Resource
Name (ARN) for the identifier so that Amazon DocumentDB can locate the
cluster in its Amazon Web Services region.

Constraints:
\itemize{
\item Must match the identifier of an existing secondary cluster.
\item Minimum length of 1. Maximum length of 255.
}

Pattern: \verb{[A-Za-z][0-9A-Za-z-:._]*}}
}
\description{
Switches over the specified secondary Amazon DocumentDB cluster to be the new primary Amazon DocumentDB cluster in the global database cluster.

See \url{https://www.paws-r-sdk.com/docs/docdb_switchover_global_cluster/} for full documentation.
}
\keyword{internal}
