% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftdataapiservice_operations.R
\name{redshiftdataapiservice_execute_statement}
\alias{redshiftdataapiservice_execute_statement}
\title{Runs an SQL statement, which can be data manipulation language (DML) or
data definition language (DDL)}
\usage{
redshiftdataapiservice_execute_statement(
  ClientToken = NULL,
  ClusterIdentifier = NULL,
  Database = NULL,
  DbUser = NULL,
  Parameters = NULL,
  SecretArn = NULL,
  SessionId = NULL,
  SessionKeepAliveSeconds = NULL,
  Sql,
  StatementName = NULL,
  WithEvent = NULL,
  WorkgroupName = NULL
)
}
\arguments{
\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{ClusterIdentifier}{The cluster identifier. This parameter is required when connecting to a
cluster and authenticating using either Secrets Manager or temporary
credentials.}

\item{Database}{The name of the database. This parameter is required when authenticating
using either Secrets Manager or temporary credentials.}

\item{DbUser}{The database user name. This parameter is required when connecting to a
cluster as a database user and authenticating using temporary
credentials.}

\item{Parameters}{The parameters for the SQL statement.}

\item{SecretArn}{The name or ARN of the secret that enables access to the database. This
parameter is required when authenticating using Secrets Manager.}

\item{SessionId}{The session identifier of the query.}

\item{SessionKeepAliveSeconds}{The number of seconds to keep the session alive after the query
finishes. The maximum time a session can keep alive is 24 hours. After
24 hours, the session is forced closed and the query is terminated.}

\item{Sql}{[required] The SQL statement text to run.}

\item{StatementName}{The name of the SQL statement. You can name the SQL statement when you
create it to identify the query.}

\item{WithEvent}{A value that indicates whether to send an event to the Amazon
EventBridge event bus after the SQL statement runs.}

\item{WorkgroupName}{The serverless workgroup name or Amazon Resource Name (ARN). This
parameter is required when connecting to a serverless workgroup and
authenticating using either Secrets Manager or temporary credentials.}
}
\description{
Runs an SQL statement, which can be data manipulation language (DML) or data definition language (DDL). This statement must be a single SQL statement. Depending on the authorization method, use one of the following combinations of request parameters:

See \url{https://www.paws-r-sdk.com/docs/redshiftdataapiservice_execute_statement/} for full documentation.
}
\keyword{internal}
