% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeformation_operations.R
\name{lakeformation_get_temporary_glue_partition_credentials}
\alias{lakeformation_get_temporary_glue_partition_credentials}
\title{This API is identical to GetTemporaryTableCredentials except that this
is used when the target Data Catalog resource is of type Partition}
\usage{
lakeformation_get_temporary_glue_partition_credentials(
  TableArn,
  Partition,
  Permissions = NULL,
  DurationSeconds = NULL,
  AuditContext = NULL,
  SupportedPermissionTypes = NULL
)
}
\arguments{
\item{TableArn}{[required] The ARN of the partitions' table.}

\item{Partition}{[required] A list of partition values identifying a single partition.}

\item{Permissions}{Filters the request based on the user having been granted a list of
specified permissions on the requested resource(s).}

\item{DurationSeconds}{The time period, between 900 and 21,600 seconds, for the timeout of the
temporary credentials.}

\item{AuditContext}{A structure representing context to access a resource (column names,
query ID, etc).}

\item{SupportedPermissionTypes}{A list of supported permission types for the partition. Valid values are
\code{COLUMN_PERMISSION} and \code{CELL_FILTER_PERMISSION}.}
}
\description{
This API is identical to \code{GetTemporaryTableCredentials} except that this is used when the target Data Catalog resource is of type Partition. Lake Formation restricts the permission of the vended credentials with the same scope down policy which restricts access to a single Amazon S3 prefix.

See \url{https://www.paws-r-sdk.com/docs/lakeformation_get_temporary_glue_partition_credentials/} for full documentation.
}
\keyword{internal}
