% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_start_db_instance_automated_backups_replication}
\alias{rds_start_db_instance_automated_backups_replication}
\title{Enables replication of automated backups to a different Amazon Web
Services Region}
\usage{
rds_start_db_instance_automated_backups_replication(
  SourceDBInstanceArn,
  BackupRetentionPeriod = NULL,
  KmsKeyId = NULL,
  PreSignedUrl = NULL
)
}
\arguments{
\item{SourceDBInstanceArn}{[required] The Amazon Resource Name (ARN) of the source DB instance for the
replicated automated backups, for example,
\code{arn:aws:rds:us-west-2:123456789012:db:mydatabase}.}

\item{BackupRetentionPeriod}{The retention period for the replicated automated backups.}

\item{KmsKeyId}{The Amazon Web Services KMS key identifier for encryption of the
replicated automated backups. The KMS key ID is the Amazon Resource Name
(ARN) for the KMS encryption key in the destination Amazon Web Services
Region, for example,
\code{arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE}.}

\item{PreSignedUrl}{In an Amazon Web Services GovCloud (US) Region, an URL that contains a
Signature Version 4 signed request for the
\code{\link[=rds_start_db_instance_automated_backups_replication]{start_db_instance_automated_backups_replication}}
operation to call in the Amazon Web Services Region of the source DB
instance. The presigned URL must be a valid request for the
\code{\link[=rds_start_db_instance_automated_backups_replication]{start_db_instance_automated_backups_replication}}
API operation that can run in the Amazon Web Services Region that
contains the source DB instance.

This setting applies only to Amazon Web Services GovCloud (US) Regions.
It's ignored in other Amazon Web Services Regions.

To learn how to generate a Signature Version 4 signed request, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html}{Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)}
and \href{https://docs.aws.amazon.com/general/latest/gr/signing-aws-api-requests.html}{Signature Version 4 Signing Process}.

If you are using an Amazon Web Services SDK tool or the CLI, you can
specify \code{SourceRegion} (or \code{--source-region} for the CLI) instead of
specifying \code{PreSignedUrl} manually. Specifying \code{SourceRegion}
autogenerates a presigned URL that is a valid request for the operation
that can run in the source Amazon Web Services Region.}
}
\description{
Enables replication of automated backups to a different Amazon Web Services Region.

See \url{https://paws-r.github.io/docs/rds/start_db_instance_automated_backups_replication.html} for full documentation.
}
\keyword{internal}
