% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_download_db_log_file_portion}
\alias{rds_download_db_log_file_portion}
\title{Downloads all or a portion of the specified log file, up to 1 MB in size}
\usage{
rds_download_db_log_file_portion(DBInstanceIdentifier, LogFileName,
  Marker, NumberOfLines)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The customer-assigned name of the DB instance that contains the log
files you want to list.

Constraints:
\itemize{
\item Must match the identifier of an existing DBInstance.
}}

\item{LogFileName}{[required] The name of the log file to be downloaded.}

\item{Marker}{The pagination token provided in the previous request or \"0\". If the
Marker parameter is specified the response includes only records beyond
the marker until the end of the file or up to NumberOfLines.}

\item{NumberOfLines}{The number of lines to download. If the number of lines specified
results in a file over 1 MB in size, the file is truncated at 1 MB in
size.

If the NumberOfLines parameter is specified, then the block of lines
returned can be from the beginning or the end of the log file, depending
on the value of the Marker parameter.
\itemize{
\item If neither Marker or NumberOfLines are specified, the entire log
file is returned up to a maximum of 10000 lines, starting with the
most recent log entries first.
\item If NumberOfLines is specified and Marker isn\'t specified, then the
most recent lines from the end of the log file are returned.
\item If Marker is specified as \"0\", then the specified number of lines
from the beginning of the log file are returned.
\item You can download the log file in blocks of lines by specifying the
size of the block using the NumberOfLines parameter, and by
specifying a value of \"0\" for the Marker parameter in your first
request. Include the Marker value returned in the response as the
Marker value for the next request, continuing until the
AdditionalDataPending response element returns false.
}}
}
\description{
Downloads all or a portion of the specified log file, up to 1 MB in
size.
}
\section{Request syntax}{
\preformatted{svc$download_db_log_file_portion(
  DBInstanceIdentifier = "string",
  LogFileName = "string",
  Marker = "string",
  NumberOfLines = 123
)
}
}

\keyword{internal}
