% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_create_db_cluster_parameter_group}
\alias{neptune_create_db_cluster_parameter_group}
\title{Creates a new DB cluster parameter group}
\usage{
neptune_create_db_cluster_parameter_group(DBClusterParameterGroupName,
  DBParameterGroupFamily, Description, Tags)
}
\arguments{
\item{DBClusterParameterGroupName}{[required] The name of the DB cluster parameter group.

Constraints:
\itemize{
\item Must match the name of an existing DBClusterParameterGroup.
}

This value is stored as a lowercase string.}

\item{DBParameterGroupFamily}{[required] The DB cluster parameter group family name. A DB cluster parameter group
can be associated with one and only one DB cluster parameter group
family, and can be applied only to a DB cluster running a database
engine and engine version compatible with that DB cluster parameter
group family.}

\item{Description}{[required] The description for the DB cluster parameter group.}

\item{Tags}{The tags to be assigned to the new DB cluster parameter group.}
}
\description{
Creates a new DB cluster parameter group.
}
\details{
Parameters in a DB cluster parameter group apply to all of the instances
in a DB cluster.

A DB cluster parameter group is initially created with the default
parameters for the database engine used by instances in the DB cluster.
To provide custom values for any of the parameters, you must modify the
group after creating it using ModifyDBClusterParameterGroup. Once
you\'ve created a DB cluster parameter group, you need to associate it
with your DB cluster using ModifyDBCluster. When you associate a new DB
cluster parameter group with a running DB cluster, you need to reboot
the DB instances in the DB cluster without failover for the new DB
cluster parameter group and associated settings to take effect.

After you create a DB cluster parameter group, you should wait at least
5 minutes before creating your first DB cluster that uses that DB
cluster parameter group as the default parameter group. This allows
Amazon Neptune to fully complete the create action before the DB cluster
parameter group is used as the default for a new DB cluster. This is
especially important for parameters that are critical when creating the
default database for a DB cluster, such as the character set for the
default database defined by the \code{character_set_database} parameter. You
can use the \emph{Parameter Groups} option of the \href{https://console.aws.amazon.com/rds/}{Amazon Neptune console} or the
DescribeDBClusterParameters command to verify that your DB cluster
parameter group has been created or modified.
}
\section{Request syntax}{
\preformatted{svc$create_db_cluster_parameter_group(
  DBClusterParameterGroupName = "string",
  DBParameterGroupFamily = "string",
  Description = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
