% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_reset_cache_parameter_group}
\alias{elasticache_reset_cache_parameter_group}
\title{Modifies the parameters of a cache parameter group to the engine or
system default value}
\usage{
elasticache_reset_cache_parameter_group(CacheParameterGroupName,
  ResetAllParameters, ParameterNameValues)
}
\arguments{
\item{CacheParameterGroupName}{[required] The name of the cache parameter group to reset.}

\item{ResetAllParameters}{If \code{true}, all parameters in the cache parameter group are reset to
their default values. If \code{false}, only the parameters listed by
\code{ParameterNameValues} are reset to their default values.

Valid values: \code{true} \\| \code{false}}

\item{ParameterNameValues}{An array of parameter names to reset to their default values. If
\code{ResetAllParameters} is \code{true}, do not use \code{ParameterNameValues}. If
\code{ResetAllParameters} is \code{false}, you must specify the name of at least
one parameter to reset.}
}
\description{
Modifies the parameters of a cache parameter group to the engine or
system default value. You can reset specific parameters by submitting a
list of parameter names. To reset the entire cache parameter group,
specify the \code{ResetAllParameters} and \code{CacheParameterGroupName}
parameters.
}
\section{Request syntax}{
\preformatted{svc$reset_cache_parameter_group(
  CacheParameterGroupName = "string",
  ResetAllParameters = TRUE|FALSE,
  ParameterNameValues = list(
    list(
      ParameterName = "string",
      ParameterValue = "string"
    )
  )
)
}
}

\keyword{internal}
