% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_describe_reserved_cache_nodes}
\alias{elasticache_describe_reserved_cache_nodes}
\title{Returns information about reserved cache nodes for this account, or
about a specified reserved cache node}
\usage{
elasticache_describe_reserved_cache_nodes(ReservedCacheNodeId,
  ReservedCacheNodesOfferingId, CacheNodeType, Duration,
  ProductDescription, OfferingType, MaxRecords, Marker)
}
\arguments{
\item{ReservedCacheNodeId}{The reserved cache node identifier filter value. Use this parameter to
show only the reservation that matches the specified reservation ID.}

\item{ReservedCacheNodesOfferingId}{The offering identifier filter value. Use this parameter to show only
purchased reservations matching the specified offering identifier.}

\item{CacheNodeType}{The cache node type filter value. Use this parameter to show only those
reservations matching the specified cache node type.

The following node types are supported by ElastiCache. Generally
speaking, the current generation types provide more memory and
computational power at lower cost when compared to their equivalent
previous generation counterparts.
\itemize{
\item General purpose:
\itemize{
\item Current generation:

\strong{M5 node types:} \code{cache.m5.large}, \code{cache.m5.xlarge},
\code{cache.m5.2xlarge}, \code{cache.m5.4xlarge}, \code{cache.m5.12xlarge},
\code{cache.m5.24xlarge}

\strong{M4 node types:} \code{cache.m4.large}, \code{cache.m4.xlarge},
\code{cache.m4.2xlarge}, \code{cache.m4.4xlarge}, \code{cache.m4.10xlarge}

\strong{T2 node types:} \code{cache.t2.micro}, \code{cache.t2.small},
\code{cache.t2.medium}
\item Previous generation: (not recommended)

\strong{T1 node types:} \code{cache.t1.micro}

\strong{M1 node types:} \code{cache.m1.small}, \code{cache.m1.medium},
\code{cache.m1.large}, \code{cache.m1.xlarge}

\strong{M3 node types:} \code{cache.m3.medium}, \code{cache.m3.large},
\code{cache.m3.xlarge}, \code{cache.m3.2xlarge}
}
\item Compute optimized:
\itemize{
\item Previous generation: (not recommended)

\strong{C1 node types:} \code{cache.c1.xlarge}
}
\item Memory optimized:
\itemize{
\item Current generation:

\strong{R5 node types:} \code{cache.r5.large}, \code{cache.r5.xlarge},
\code{cache.r5.2xlarge}, \code{cache.r5.4xlarge}, \code{cache.r5.12xlarge},
\code{cache.r5.24xlarge}

\strong{R4 node types:} \code{cache.r4.large}, \code{cache.r4.xlarge},
\code{cache.r4.2xlarge}, \code{cache.r4.4xlarge}, \code{cache.r4.8xlarge},
\code{cache.r4.16xlarge}
\item Previous generation: (not recommended)

\strong{M2 node types:} \code{cache.m2.xlarge}, \code{cache.m2.2xlarge},
\code{cache.m2.4xlarge}

\strong{R3 node types:} \code{cache.r3.large}, \code{cache.r3.xlarge},
\code{cache.r3.2xlarge}, \code{cache.r3.4xlarge}, \code{cache.r3.8xlarge}
}
}

\strong{Additional node type info}
\itemize{
\item All current generation instance types are created in Amazon VPC by
default.
\item Redis append-only files (AOF) are not supported for T1 or T2
instances.
\item Redis Multi-AZ with automatic failover is not supported on T1
instances.
\item Redis configuration variables \code{appendonly} and \code{appendfsync} are not
supported on Redis version 2.8.22 and later.
}}

\item{Duration}{The duration filter value, specified in years or seconds. Use this
parameter to show only reservations for this duration.

Valid Values: \code{1 | 3 | 31536000 | 94608000}}

\item{ProductDescription}{The product description filter value. Use this parameter to show only
those reservations matching the specified product description.}

\item{OfferingType}{The offering type filter value. Use this parameter to show only the
available offerings matching the specified offering type.

Valid values:
\code{"Light Utilization"|"Medium Utilization"|"Heavy Utilization"}}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a marker is
included in the response so that the remaining results can be retrieved.

Default: 100

Constraints: minimum 20; maximum 100.}

\item{Marker}{An optional marker returned from a prior request. Use this marker for
pagination of results from this operation. If this parameter is
specified, the response includes only records beyond the marker, up to
the value specified by \code{MaxRecords}.}
}
\description{
Returns information about reserved cache nodes for this account, or
about a specified reserved cache node.
}
\section{Request syntax}{
\preformatted{svc$describe_reserved_cache_nodes(
  ReservedCacheNodeId = "string",
  ReservedCacheNodesOfferingId = "string",
  CacheNodeType = "string",
  Duration = "string",
  ProductDescription = "string",
  OfferingType = "string",
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
