% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_delete_cluster_snapshot}
\alias{redshift_delete_cluster_snapshot}
\title{Deletes the specified manual snapshot}
\usage{
redshift_delete_cluster_snapshot(SnapshotIdentifier,
  SnapshotClusterIdentifier)
}
\arguments{
\item{SnapshotIdentifier}{[required] The unique identifier of the manual snapshot to be deleted.

Constraints: Must be the name of an existing snapshot that is in the
\code{available}, \code{failed}, or \code{cancelled} state.}

\item{SnapshotClusterIdentifier}{The unique identifier of the cluster the snapshot was created from. This
parameter is required if your IAM user has a policy containing a
snapshot resource element that specifies anything other than \* for the
cluster name.

Constraints: Must be the name of valid cluster.}
}
\description{
Deletes the specified manual snapshot. The snapshot must be in the
\code{available} state, with no other users authorized to access the
snapshot.
}
\details{
Unlike automated snapshots, manual snapshots are retained even after you
delete your cluster. Amazon Redshift does not delete your manual
snapshots. You must delete manual snapshot explicitly to avoid getting
charged. If other accounts are authorized to access the snapshot, you
must revoke all of the authorizations before you can delete the
snapshot.
}
\section{Request syntax}{
\preformatted{svc$delete_cluster_snapshot(
  SnapshotIdentifier = "string",
  SnapshotClusterIdentifier = "string"
)
}
}

\keyword{internal}
