% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_transact_write_items}
\alias{dynamodb_transact_write_items}
\title{TransactWriteItems is a synchronous write operation that groups up to 25
action requests}
\usage{
dynamodb_transact_write_items(TransactItems, ReturnConsumedCapacity,
  ReturnItemCollectionMetrics, ClientRequestToken)
}
\arguments{
\item{TransactItems}{[required] An ordered array of up to 25 \code{TransactWriteItem} objects, each of which
contains a \code{ConditionCheck}, \code{Put}, \code{Update}, or \code{Delete} object. These
can operate on items in different tables, but the tables must reside in
the same AWS account and Region, and no two of them can operate on the
same item.}

\item{ReturnConsumedCapacity}{}

\item{ReturnItemCollectionMetrics}{Determines whether item collection metrics are returned. If set to
\code{SIZE}, the response includes statistics about item collections (if
any), that were modified during the operation and are returned in the
response. If set to \code{NONE} (the default), no statistics are returned.}

\item{ClientRequestToken}{Providing a \code{ClientRequestToken} makes the call to
\code{\link[=dynamodb_transact_write_items]{transact_write_items}} idempotent,
meaning that multiple identical calls have the same effect as one single
call.

Although multiple identical calls using the same client request token
produce the same result on the server (no side effects), the responses
to the calls might not be the same. If the \verb{ReturnConsumedCapacity>}
parameter is set, then the initial
\code{\link[=dynamodb_transact_write_items]{transact_write_items}} call returns the
amount of write capacity units consumed in making the changes.
Subsequent \code{\link[=dynamodb_transact_write_items]{transact_write_items}} calls
with the same client token return the number of read capacity units
consumed in reading the item.

A client request token is valid for 10 minutes after the first request
that uses it is completed. After 10 minutes, any request with the same
client token is treated as a new request. Do not resubmit the same
request with the same client token for more than 10 minutes, or the
result might not be idempotent.

If you submit a request with the same client token but a change in other
parameters within the 10-minute idempotency window, DynamoDB returns an
\code{IdempotentParameterMismatch} exception.}
}
\value{
A list with the following syntax:\preformatted{list(
  ConsumedCapacity = list(
    list(
      TableName = "string",
      CapacityUnits = 123.0,
      ReadCapacityUnits = 123.0,
      WriteCapacityUnits = 123.0,
      Table = list(
        ReadCapacityUnits = 123.0,
        WriteCapacityUnits = 123.0,
        CapacityUnits = 123.0
      ),
      LocalSecondaryIndexes = list(
        list(
          ReadCapacityUnits = 123.0,
          WriteCapacityUnits = 123.0,
          CapacityUnits = 123.0
        )
      ),
      GlobalSecondaryIndexes = list(
        list(
          ReadCapacityUnits = 123.0,
          WriteCapacityUnits = 123.0,
          CapacityUnits = 123.0
        )
      )
    )
  ),
  ItemCollectionMetrics = list(
    list(
      list(
        ItemCollectionKey = list(
          list(
            S = "string",
            N = "string",
            B = raw,
            SS = list(
              "string"
            ),
            NS = list(
              "string"
            ),
            BS = list(
              raw
            ),
            M = list(
              list()
            ),
            L = list(
              list()
            ),
            NULL = TRUE|FALSE,
            BOOL = TRUE|FALSE
          )
        ),
        SizeEstimateRangeGB = list(
          123.0
        )
      )
    )
  )
)
}
}
\description{
\code{\link[=dynamodb_transact_write_items]{transact_write_items}} is a synchronous
write operation that groups up to 25 action requests. These actions can
target items in different tables, but not in different AWS accounts or
Regions, and no two actions can target the same item. For example, you
cannot both \code{ConditionCheck} and \code{Update} the same item. The aggregate
size of the items in the transaction cannot exceed 4 MB.

The actions are completed atomically so that either all of them succeed,
or all of them fail. They are defined by the following objects:
\itemize{
\item \code{Put}  —   Initiates a \code{\link[=dynamodb_put_item]{put_item}} operation to
write a new item. This structure specifies the primary key of the
item to be written, the name of the table to write it in, an
optional condition expression that must be satisfied for the write
to succeed, a list of the item's attributes, and a field indicating
whether to retrieve the item's attributes if the condition is not
met.
\item \code{Update}  —   Initiates an \code{\link[=dynamodb_update_item]{update_item}}
operation to update an existing item. This structure specifies the
primary key of the item to be updated, the name of the table where
it resides, an optional condition expression that must be satisfied
for the update to succeed, an expression that defines one or more
attributes to be updated, and a field indicating whether to retrieve
the item's attributes if the condition is not met.
\item \code{Delete}  —   Initiates a \code{\link[=dynamodb_delete_item]{delete_item}}
operation to delete an existing item. This structure specifies the
primary key of the item to be deleted, the name of the table where
it resides, an optional condition expression that must be satisfied
for the deletion to succeed, and a field indicating whether to
retrieve the item's attributes if the condition is not met.
\item \code{ConditionCheck}  —   Applies a condition to an item that is not
being modified by the transaction. This structure specifies the
primary key of the item to be checked, the name of the table where
it resides, a condition expression that must be satisfied for the
transaction to succeed, and a field indicating whether to retrieve
the item's attributes if the condition is not met.
}

DynamoDB rejects the entire
\code{\link[=dynamodb_transact_write_items]{transact_write_items}} request if any
of the following is true:
\itemize{
\item A condition in one of the condition expressions is not met.
\item An ongoing operation is in the process of updating the same item.
\item There is insufficient provisioned capacity for the transaction to be
completed.
\item An item size becomes too large (bigger than 400 KB), a local
secondary index (LSI) becomes too large, or a similar validation
error occurs because of changes made by the transaction.
\item The aggregate size of the items in the transaction exceeds 4 MB.
\item There is a user error, such as an invalid data format.
}
}
\section{Request syntax}{
\preformatted{svc$transact_write_items(
  TransactItems = list(
    list(
      ConditionCheck = list(
        Key = list(
          list(
            S = "string",
            N = "string",
            B = raw,
            SS = list(
              "string"
            ),
            NS = list(
              "string"
            ),
            BS = list(
              raw
            ),
            M = list(
              list()
            ),
            L = list(
              list()
            ),
            NULL = TRUE|FALSE,
            BOOL = TRUE|FALSE
          )
        ),
        TableName = "string",
        ConditionExpression = "string",
        ExpressionAttributeNames = list(
          "string"
        ),
        ExpressionAttributeValues = list(
          list(
            S = "string",
            N = "string",
            B = raw,
            SS = list(
              "string"
            ),
            NS = list(
              "string"
            ),
            BS = list(
              raw
            ),
            M = list(
              list()
            ),
            L = list(
              list()
            ),
            NULL = TRUE|FALSE,
            BOOL = TRUE|FALSE
          )
        ),
        ReturnValuesOnConditionCheckFailure = "ALL_OLD"|"NONE"
      ),
      Put = list(
        Item = list(
          list(
            S = "string",
            N = "string",
            B = raw,
            SS = list(
              "string"
            ),
            NS = list(
              "string"
            ),
            BS = list(
              raw
            ),
            M = list(
              list()
            ),
            L = list(
              list()
            ),
            NULL = TRUE|FALSE,
            BOOL = TRUE|FALSE
          )
        ),
        TableName = "string",
        ConditionExpression = "string",
        ExpressionAttributeNames = list(
          "string"
        ),
        ExpressionAttributeValues = list(
          list(
            S = "string",
            N = "string",
            B = raw,
            SS = list(
              "string"
            ),
            NS = list(
              "string"
            ),
            BS = list(
              raw
            ),
            M = list(
              list()
            ),
            L = list(
              list()
            ),
            NULL = TRUE|FALSE,
            BOOL = TRUE|FALSE
          )
        ),
        ReturnValuesOnConditionCheckFailure = "ALL_OLD"|"NONE"
      ),
      Delete = list(
        Key = list(
          list(
            S = "string",
            N = "string",
            B = raw,
            SS = list(
              "string"
            ),
            NS = list(
              "string"
            ),
            BS = list(
              raw
            ),
            M = list(
              list()
            ),
            L = list(
              list()
            ),
            NULL = TRUE|FALSE,
            BOOL = TRUE|FALSE
          )
        ),
        TableName = "string",
        ConditionExpression = "string",
        ExpressionAttributeNames = list(
          "string"
        ),
        ExpressionAttributeValues = list(
          list(
            S = "string",
            N = "string",
            B = raw,
            SS = list(
              "string"
            ),
            NS = list(
              "string"
            ),
            BS = list(
              raw
            ),
            M = list(
              list()
            ),
            L = list(
              list()
            ),
            NULL = TRUE|FALSE,
            BOOL = TRUE|FALSE
          )
        ),
        ReturnValuesOnConditionCheckFailure = "ALL_OLD"|"NONE"
      ),
      Update = list(
        Key = list(
          list(
            S = "string",
            N = "string",
            B = raw,
            SS = list(
              "string"
            ),
            NS = list(
              "string"
            ),
            BS = list(
              raw
            ),
            M = list(
              list()
            ),
            L = list(
              list()
            ),
            NULL = TRUE|FALSE,
            BOOL = TRUE|FALSE
          )
        ),
        UpdateExpression = "string",
        TableName = "string",
        ConditionExpression = "string",
        ExpressionAttributeNames = list(
          "string"
        ),
        ExpressionAttributeValues = list(
          list(
            S = "string",
            N = "string",
            B = raw,
            SS = list(
              "string"
            ),
            NS = list(
              "string"
            ),
            BS = list(
              raw
            ),
            M = list(
              list()
            ),
            L = list(
              list()
            ),
            NULL = TRUE|FALSE,
            BOOL = TRUE|FALSE
          )
        ),
        ReturnValuesOnConditionCheckFailure = "ALL_OLD"|"NONE"
      )
    )
  ),
  ReturnConsumedCapacity = "INDEXES"|"TOTAL"|"NONE",
  ReturnItemCollectionMetrics = "SIZE"|"NONE",
  ClientRequestToken = "string"
)
}
}

\keyword{internal}
