% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_get_reserved_node_exchange_offerings}
\alias{redshift_get_reserved_node_exchange_offerings}
\title{Returns an array of DC2 ReservedNodeOfferings that matches the payment
type, term, and usage price of the given DC1 reserved node}
\usage{
redshift_get_reserved_node_exchange_offerings(ReservedNodeId,
  MaxRecords, Marker)
}
\arguments{
\item{ReservedNodeId}{[required] A string representing the node identifier for the DC1 Reserved Node to
be exchanged.}

\item{MaxRecords}{An integer setting the maximum number of ReservedNodeOfferings to
retrieve.}

\item{Marker}{A value that indicates the starting point for the next set of
ReservedNodeOfferings.}
}
\description{
Returns an array of DC2 ReservedNodeOfferings that matches the payment
type, term, and usage price of the given DC1 reserved node.
}
\section{Request syntax}{
\preformatted{svc$get_reserved_node_exchange_offerings(
  ReservedNodeId = "string",
  MaxRecords = 123,
  Marker = "string"
)
}
}

\keyword{internal}
