% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_copy_db_cluster_parameter_group}
\alias{docdb_copy_db_cluster_parameter_group}
\title{Copies the specified cluster parameter group}
\usage{
docdb_copy_db_cluster_parameter_group(
  SourceDBClusterParameterGroupIdentifier,
  TargetDBClusterParameterGroupIdentifier,
  TargetDBClusterParameterGroupDescription, Tags)
}
\arguments{
\item{SourceDBClusterParameterGroupIdentifier}{[required] The identifier or Amazon Resource Name (ARN) for the source cluster
parameter group.

Constraints:
\itemize{
\item Must specify a valid cluster parameter group.
\item If the source cluster parameter group is in the same AWS Region as
the copy, specify a valid parameter group identifier; for example,
\code{my-db-cluster-param-group}, or a valid ARN.
\item If the source parameter group is in a different AWS Region than the
copy, specify a valid cluster parameter group ARN; for example,
\code{arn:aws:rds:us-east-1:123456789012:sample-cluster:sample-parameter-group}.
}}

\item{TargetDBClusterParameterGroupIdentifier}{[required] The identifier for the copied cluster parameter group.

Constraints:
\itemize{
\item Cannot be null, empty, or blank.
\item Must contain from 1 to 255 letters, numbers, or hyphens.
\item The first character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster-param-group1}}

\item{TargetDBClusterParameterGroupDescription}{[required] A description for the copied cluster parameter group.}

\item{Tags}{The tags that are to be assigned to the parameter group.}
}
\description{
Copies the specified cluster parameter group.
}
\section{Request syntax}{
\preformatted{svc$copy_db_cluster_parameter_group(
  SourceDBClusterParameterGroupIdentifier = "string",
  TargetDBClusterParameterGroupIdentifier = "string",
  TargetDBClusterParameterGroupDescription = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
