% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PC.Mk.II.Lightweight.R
\name{pcLightweight}
\alias{pcLightweight}
\title{Pattern Causality Lightweight Function}
\usage{
pcLightweight(X, Y, E, tau, metric, h, weighted, tpb = TRUE)
}
\arguments{
\item{X}{A numeric vector representing the first time series.}

\item{Y}{A numeric vector representing the second time series.}

\item{E}{The embedding dimension, which influences the number of dimensions in which the time series is reconstructed for analysis.}

\item{tau}{The time delay used in reconstructing the time series in the embedded space.}

\item{metric}{A character string indicating the distance metric to be used (e.g., 'euclidean', 'maximum').}

\item{h}{The prediction horizon, representing the number of steps ahead for which predictions are needed.}

\item{weighted}{A logical indicating whether to use a weighted approach in the causality strength calculations.}

\item{tpb}{A bool parameter to show progress bar.}
}
\value{
A data frame with columns for total, positive, negative, and dark causality percentages across evaluated time points, giving insights into the nature of causality between the time series.
}
\description{
This function implements the Pattern Causality Model Mk. II for lightweight analysis of causal interactions between two time series using pattern and signature spaces. It assesses causality through reconstructed state spaces and hashed pattern analysis.
}
\examples{
data(climate_indices)
X <- climate_indices$AO
Y <- climate_indices$AAO
result <- pcLightweight(X, Y, E = 3, tau = 1, metric = "euclidean", h = 2, weighted = TRUE)
print(result)
}
