% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantitate.R
\name{quantitate}
\alias{quantitate}
\title{Combine technical replicates and quantitate proteins}
\usage{
quantitate(reps, normalize = T, match_peps = T, relabel = c())
}
\arguments{
\item{reps}{Vector. List of thermo MSF file names}

\item{normalize}{Boolean. Should we normalize peptide areas for technical replicate to the total areas in a given replicate?}

\item{match_peps}{Boolean. Should we quantitate only on matching peptides across technical replicates?}

\item{relabel}{Named vector for relabeling protein groups. Names correspond to a pattern or string to match (i.e. the name or ID of a protein group), and values correspond to the new value (i.e. new protein group name).}
}
\value{
A data frame containing area information for all proteins.

\item{protein_desc}{protein description}
\item{area_mean}{average peptide area}
\item{area_sd}{peptide area standard deviation}
\item{peps_per_rep}{Number of peptides per technical replicate used to calculate \code{area_mean} and \code{area_sd}. This is typically 3 peptides, but may be less.}
}
\description{
Takes a list of thermo MSF files, parses and combines them into a single data frame, and computes areas for each protein group based on the top 3 method of quantitation.
}
\examples{
quantitate(c(parsemsf_example("test_db.msf"),
             parsemsf_example("test_db2.msf")),
           relabel = c("NP_12345.1" = "NP_1000.1"))
}

