% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_lab.R
\encoding{UTF-8}
\name{convert_lab}
\alias{convert_lab}
\title{Converts lab results to normal/abnormal based-on reference values.}
\usage{
convert_lab(
  d,
  code_results = "lab_result",
  code_reference = "lab_result_range"
)
}
\arguments{
\item{d}{data.table, database containing laboratory results data loaded using the \emph{load_lab} function.}

\item{code_results}{string vector, column name containing the results. Defaults to: \emph{"lab_result"}.}

\item{code_reference}{string vector, column name containing the reference ranges Defaults to: \emph{"lab_result_range"}.}
}
\value{
data.table, with two additional columns: \emph{"lab_result_pretty"} containing numerical results. In case of ">" or "<" notation,
the numeric value is returned, as we only have information that it is at least as much or not larger than a given value.
The other column: \emph{"lab_result_abn_pretty"} can take values: NORMAL/ABNORMAL, depending on whether the value is within the reference range.
Borderline values are considered NORMAL.
}
\description{
Analyzes laboratory data loaded using \emph{load_lab}. Converts laboratory results to values without ">" or "<" by creating a column where these characters are removed.
Furthermore, adds an indicator column where based-on the reference ranges, the value is considered normal or abnormal.
}
\examples{
\dontrun{
#Convert loaded lab results
data_lab_pretty <- convert_lab(d = data_lab)
data_lab_pretty[, c("lab_result", "lab_result_pretty", "lab_result_range", "lab_result_abn_pretty")]
}
}
