% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_formatting.R
\name{signif_column}
\alias{signif_column}
\title{Creating a new column with significance labels}
\usage{
signif_column(data, p, messages = FALSE)
}
\arguments{
\item{data}{Data frame from which variables specified are preferentially to
be taken.}

\item{p}{The column containing \emph{p}-values.}

\item{messages}{Logical decides whether to produce notes (Default: \code{TRUE}).}
}
\value{
Returns the dataframe in tibble format with an additional column
corresponding to APA-format statistical significance labels.
}
\description{
This function will add a new column with significance labels to
a dataframe containing \emph{p}-values.
}
\examples{
library(pairwiseComparisons)

# preparing a newdataframe
df <- cbind.data.frame(
  x = 1:5,
  y = 1,
  p.value = c(0.1, 0.5, 0.00001, 0.05, 0.01)
)

# dataframe with significance column
pairwiseComparisons::signif_column(data = df, p = p.value)
}
\author{
Indrajeet Patil
}
\concept{helper_stats}
