% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{outerbase}
\alias{outerbase}
\alias{Rcpp_outerbase-class}
\alias{Rcpp_outerbase}
\title{Outer product-type basis}
\arguments{
\item{x}{a matrix of predictors, must have as many columns as dims in 
\code{om}}
}
\value{
no returns, this is a class which contains methods
}
\description{
\preformatted{
ob = new(outerbase, om, x)
}
Class that handles the basis for a given set of points 
\code{x}.
}
\section{Fields}{

\describe{
\item{\code{nthreads}}{number of threads for \code{omp} to use}

\item{\code{\link{outerbase$getbase}(k)}}{to get each dimensions basis 
functions}

\item{\code{\link{outerbase$getmat}(terms)}}{to get the basis matrix at 
\code{terms}}

\item{\code{\link{outerbase$build}()}}{to (re)build the basis instance}

\item{\code{\link{outerbase$matmul}(terms,a)}}{matrix multiply without 
building the basis matrix}

\item{\code{\link{outerbase$tmatmul}(terms,a)}}{transpose matrix multiply 
without building the basis matrix}
}}

\examples{
om = new(outermod)
setcovfs(om, c("mat25", "mat25", "mat25"))
setknot(om,
         list(seq(0,1,by=0.025),seq(0,1,by=0.025),seq(0,1,by=0.025)))
x = matrix(runif(10*3),ncol=3)
ob = new(outerbase, om, x)
terms = om$selectterms(40)
basismat = ob$getmat(terms)
}
\seealso{
\code{\link{outermod}} the core element that controls outerbase
}
