% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/add-osm-groups.R
\name{add_osm_groups}
\alias{add_osm_groups}
\title{add_osm_groups}
\usage{
add_osm_groups(obj = obj, groups = NULL, make_hull = FALSE,
  boundary = -1, cols = NULL, col_extra = NULL, colmat = TRUE,
  rotate = NULL, lwd = 0)
}
\arguments{
\item{obj}{An sp SPDF or SLDF (list of polygons or lines) returned by
extract_osm_objects()}

\item{groups}{A list of spatial points objects, each of which contains the
coordinates of points defining one group}

\item{make_hull}{Either a single boolean value or a vector of same length as
groups specifying whether a convex hull should be constructed around the
group (TRUE), or whether they group already defines a hull (convex or
otherwise; FALSE).}

\item{boundary}{(negative, 0, positive) values define whether the boundary of
groups should (exlude, bisect, include) objects which straddle the precise
boundary. (Has no effect if 'col_extra' is NULL.)}

\item{cols}{Either a vector of >= 4 colours passed to colour_mat() (if
'colmat=T') to arrange as a 2-D map of visually distinct colours (default
uses rainbow colours), or (if 'colmat=F'), a vector of the same length as
groups specifying individual colours for each.}

\item{col_extra}{If NULL, then any polygons *NOT* within the convex hulls are
assigned to nearest group and coloured accordingly (and boundary has no
effect); if NOT NULL, then any polygons not within groups are coloured this
colour.}

\item{colmat}{If TRUE generates colours according to colour_mat(), otherwise
the colours of groups are specified directly by the vector of cols.}

\item{rotate}{Passed to colour_mat() to rotate colours by the specified
number of degrees clockwise.}

\item{lwd}{Width of boundary line (0 for no line)}
}
\value{
nothing (adds to graphics.device opened with plot_osm_basemap())
}
\description{
Plots spatially distinct groups of osm objects in different colours.
}
\section{Note}{

Any group that is entire contained within any other group is assumed to
represent a hole, such that points internal to the smaller contained group
are *excluded* from the group, while those outside the smaller yet inside the
bigger group are included.
}

\section{Warning}{

Bisecting objects along group boundaries ('boundary=0') can take
considerably longer than simple allocation of objects either side of
boundary.
}

