/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import opennlp.tools.util.CountedSet;

@Deprecated
public class POSDictionaryWriter {
    private Writer dictFile;
    private Map<String, Set<String>> dictionary;
    private CountedSet<String> wordCounts;
    private String newline = System.getProperty("line.separator");

    public POSDictionaryWriter(String file, String encoding) throws IOException {
        this.dictFile = encoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding) : new FileWriter(file);
        this.dictionary = new HashMap<String, Set<String>>();
        this.wordCounts = new CountedSet();
    }

    public POSDictionaryWriter(String file) throws IOException {
        this(file, null);
    }

    public void addEntry(String word, String tag) {
        Set<String> tags = this.dictionary.get(word);
        if (tags == null) {
            tags = new HashSet<String>();
            this.dictionary.put(word, tags);
        }
        tags.add(tag);
        this.wordCounts.add(word);
    }

    public void write() throws IOException {
        this.write(5);
    }

    public void write(int cutoff) throws IOException {
        for (String word : this.wordCounts) {
            if (this.wordCounts.getCount(word) < cutoff) continue;
            this.dictFile.write(word);
            Set<String> tags = this.dictionary.get(word);
            Iterator<String> ti = tags.iterator();
            while (ti.hasNext()) {
                this.dictFile.write(" ");
                this.dictFile.write(ti.next());
            }
            this.dictFile.write(this.newline);
        }
        this.dictFile.close();
    }

    private static void usage() {
        System.err.println("Usage: POSDictionaryWriter [-encoding encoding] dictionary tag_files");
        System.exit(1);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            POSDictionaryWriter.usage();
        }
        int ai = 0;
        String encoding = null;
        if (args[ai].startsWith("-encoding")) {
            if (ai + 1 >= args.length) {
                POSDictionaryWriter.usage();
            } else {
                encoding = args[ai + 1];
                ai += 2;
            }
        }
        String dictionaryFile = args[ai++];
        POSDictionaryWriter dict = new POSDictionaryWriter(dictionaryFile, encoding);
        for (int fi = ai; fi < args.length; ++fi) {
            BufferedReader in = encoding == null ? new BufferedReader(new FileReader(args[fi])) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[fi]), encoding));
            String line = in.readLine();
            while (line != null) {
                if (!line.equals("")) {
                    String[] parts = line.split("\\s+");
                    for (int pi = 0; pi < parts.length; ++pi) {
                        int index = parts[pi].lastIndexOf(95);
                        String word = parts[pi].substring(0, index);
                        String tag = parts[pi].substring(index + 1);
                        dict.addEntry(word, tag);
                    }
                }
                line = in.readLine();
            }
        }
        dict.write();
    }
}

