% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/npIntFactRep.R
\name{npIntFactRep}
\alias{npIntFactRep}
\title{Nonparametric Aligned Ranks Function}
\usage{
npIntFactRep(dat,rank)
}
\arguments{
\item{dat}{data set in wide (one row per subject) format, see examples
- must have subj as name (header) of numeric var for units of obs id
- must have group as name of numeric var for between factor}

\item{rank}{numbers 1, 2 or 3; resp. for Regular, Friedman, or Koch ranks}
}
\value{
summary of (aov) Anova F-tests and p-value
}
\description{
Nonparametric test for interactions in two-way factorial designs
with repeated measures - "summary" of full model "aov" on (for interaction) aligned ranks
}
\details{
desired ranks numbers:
1 Regular ranks of aligned data
2 Friedman ranks of aligned data
3 Koch ranks
Returns ANOVA F test and probabilities.
Only the resulting values for 'group x time' ('between x within') are relevant
}
\examples{
\dontrun{
dat1 <- read.csv (file="c:/R/wide.csv", head=T)
#REGULAR
npIntFactRep(dat1,1)
}
dat2 <- read.table(header = TRUE, text = "
subj group m1 m2 m3 m4
1 1 1 2 3 4
2 1 2 2 3 3
3 1 1 3 3 4
4 2 8 6 4 2
5 2 6 6 4 4
6 2 8 6 6 2
")
#FRIEDMAN
npIntFactRep(dat2,2)
dat3 <- read.table(header = TRUE, text = "
subj group 1 2 3 4 5
1 1 1 2 3 4 5
2 1 2 2 3 3 3
3 1 1 3 3 4 2
4 2 8 6 4 2 1
5 2 6 6 4 4 4
6 2 8 6 6 2 3
")
#KOCH Ranks
npIntFactRep(dat3,3)
}
\author{
Jos Feys
}
\references{
Higgins, J.J., & Tashtoush, S. (1994). "An aligned rank transform test for interaction".
Nonlinear World, 1, 201-211.
Beasley, T.M., & Zumbo, B.D. (2009). "Aligned rank tests for interactions
in split-plot designs: Distributional assumptions and stochastic homogeneity".
Journal of Modern Applied Statistical Methods, 8, 16-50.
}

