% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_normal.R
\name{sim_normal}
\alias{sim_normal}
\title{Simulate sequences for a given evolutionary tree, using a standard model
of sequence evolution along the branches. Code for this function was heavily
inspired by the function \code{simSeq} from the phangorn package.}
\usage{
sim_normal(x, l = 1000, Q = NULL, bf = NULL, rootseq = NULL, rate = 1)
}
\arguments{
\item{x}{a phylogenetic tree \code{tree}, i.e. an object of class
\code{phylo}}

\item{l}{length of the sequence to simulate.}

\item{Q}{the rate matrix.}

\item{bf}{base frequencies.}

\item{rootseq}{a vector of length l containing the root sequence, other root
sequence is randomly generated.}

\item{rate}{mutation rate}
}
\value{
list with four items \enumerate{
\item{alignment} Phydat object with the resulting alignment
\item{rootseq} the rootsequence used
\item{total_branch_substitutions} total number of substitutions accumulated
on the branches
\item{total_node_substitutions} total number of substitutions accumulated at
the nodes}
}
\description{
Simulate sequences for a given evolutionary tree, using a standard model
of sequence evolution along the branches. Code for this function was heavily
inspired by the function \code{simSeq} from the phangorn package.
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
