% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impact_boot.R
\name{impact.boot}
\alias{impact.boot}
\title{Bootstrapping convenience function for impact statistics}
\usage{
impact.boot(input, boots, gamma, nodes = c("all"), binary.data = FALSE,
  weighted = TRUE, split = c("median", "mean", "forceEqual",
  "cutEqual", "quartiles"), progressbar = TRUE)
}
\arguments{
\item{input}{a matrix or data frame of observations (not a network/edgelist).
See included example datasets \code{\link{depression}} and \code{\link{social}}.}

\item{boots}{the number of times to bootstrap the impact function}

\item{gamma}{the sparsity parameter used in generating networks. Defaults to 0.5 for interval data
and 0.25 for binary data}

\item{nodes}{indicates which nodes should be tested. Can be given
as a character string of desired nodes (e.g., c("node1","node2")) or as a numeric vector of
column numbers (e.g., c(1,2)).}

\item{binary.data}{logical. Indicates whether the input data is binary}

\item{weighted}{logical. Indicates whether resultant networks preserve edge weights or binarize edges.}

\item{split}{method by which to split network given non-binary data. "median": median split (excluding the median),
"mean": mean split, "forceEqual": creates equally sized groups by partitioning random median observations
 to the smaller group, "cutEqual": creates equally sized groups by deleting random values
 from the bigger group,"quartile": uses the top and bottom quartile as groups}

\item{progressbar}{Logical. Should the pbar be plotted in order to see the progress of the estimation procedure? Defaults to TRUE.}
}
\value{
\code{\link{impact.boot}} returns a list of class "impact.boot"
}
\description{
impact.boot is DEPRECATED. The function will be removed in the next update. Use impact.NCT instead.
}
\details{
This function wraps the function \code{impact} and bootstraps to
provide confidence intervals of node impacts.

This method is computationally intensive. It is recommended that users test a subset of nodes
at a time using the \code{nodes} argument, rather than testing all nodes simultaneously.



\code{impact.boot} returns an object of class \code{impact.boot}, which includes confidence intervals.
}
\examples{
\donttest{
boot1 <- impact.boot(depression, boots=25, nodes="psychomotor_retardation")

boot2 <- impact.boot(social, boots=25, nodes="Kim", binary.data=TRUE, split="cutEqual")

##Note: for speed, 25 boots are used here; more are necessary in practice
}
}
