% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_diffnet2.r
\name{diffusionMap}
\alias{diffusionMap}
\alias{diffmap}
\alias{diffusionMap.default}
\alias{diffusionMap.diffnet}
\alias{image.diffnet_diffmap}
\alias{print.diffnet_diffmap}
\alias{plot.diffnet_diffmap}
\title{Creates a heatmap based on a graph layout and a vertex attribute}
\usage{
diffusionMap(graph, ...)

diffmap(graph, ...)

\method{diffusionMap}{default}(graph, x, x.adj = round_to_seq,
  layout = NULL, jitter.args = list(), kde2d.args = list(n = 100),
  sharp.criter = function(x, w) {     wvar(x, w) > (max(x, na.rm = TRUE) -
  min(x, na.rm = TRUE))^2/12 }, ...)

\method{diffusionMap}{diffnet}(graph, slice = nslices(graph), ...)

\method{image}{diffnet_diffmap}(x, ...)

\method{print}{diffnet_diffmap}(x, ...)

\method{plot}{diffnet_diffmap}(x, y = NULL, ...)
}
\arguments{
\item{graph}{A square matrix of size \eqn{n\times n}{n * n}.}

\item{...}{Arguments passed to method.}

\item{x}{An vector of length \eqn{n}. Usually a \code{toa} vector.}

\item{x.adj}{Function to adjust \code{x}. If not \code{NULL} then it is applied
to \code{x} at the beginning (see details).}

\item{layout}{Either a \eqn{n\times 2}{n *2} matrix of coordinates or a layout
function applied to \code{graph} (must return coordinates).}

\item{jitter.args}{A list including arguments to be passed to \code{\link{jitter}}.}

\item{kde2d.args}{A list including arguments to be passed to \code{\link[MASS:kde2d]{kde2d}}.}

\item{sharp.criter}{A function choose whether to apply a weighted mean for each cell,
or randomize over the values present in that cell (see details).}

\item{slice}{Integer scalar. Slice of the network to be used as baseline for drawing the graph.}

\item{y}{Ignored.}
}
\value{
A list of class \code{diffnet_diffmap}
\item{coords}{A matrix of size \eqn{n\times 2}{n*2} of vertices coordinates.}
\item{map}{Output from \code{kde2d}. This is a list with 3 elements, vectors
 \code{x}, \code{y} and matrix \code{z} of size \eqn{n\times n}{n*n} (passed
 via \code{kde2d.args}).}
\item{h}{Bandwidth passed to \code{kde2d}.}
}
\description{
Using bi-dimensional kernel smoothers, creates a heatmap based on a graph layout
and colored accordingly to \code{x}. This visualization technique is intended
to be used with large graphs.
}
\details{
The image is created using the function \code{kde2d} from
the \pkg{MASS} package. The complete algorithm follows:
\enumerate{
 \item \code{x} is coerced into integer and the range is adjusted to start from 1.
   \code{NA} are replaced by zero.
 \item If no \code{layout} is passed, layout is computed using
   \code{\link[igraph:layout_nicely]{layout_nicely}} from \pkg{igraph}
 \item Then, a \code{kde2d} map is computed for each level of \code{x}. The
   resulting matrices are added up as a weighted sum. This only holds if
   at the cell level the function \code{sharp.criter} returns \code{FALSE}.
 \item The jitter function is applied to the repeated coordinates.
 \item 2D kernel is computed using \code{kde2d} over the coordinates.
}

The function \code{sharp.criter} must take two values, a vector of levels and a
vector of weights. It must return a logical scalar with value equal to \code{TRUE}
when a randomization at the cell level must be done, in which case the final
value of the cell is chosen using \code{sample(x, 1, prob=w)}.

The resulting matrix can be passed to \code{\link{image}} or similar.

The argument \code{x.adj} uses by default the function \code{\link{round_to_seq}}
which basically maps \code{x} to a fix length sequence of numbers such that
\code{x.adj(x)} resembles an integer sequence.
}
\examples{

# Example with a random graph --------------------------------------------------

\dontrun{
set.seed(1231)

# Random scale-free diffusion network
x <- rdiffnet(1000, 4, seed.graph="scale-free", seed.p.adopt = .025,
                           rewire = FALSE, seed.nodes = "central",
                           rgraph.arg=list(self=FALSE, m=4),
                           threshold.dist = function(id) runif(1,.2,.4))

# Diffusion map (no random toa)
dm0 <- diffusionMap(x, kde2d.args=list(n=150, h=.5), layout=igraph::layout_with_fr)

# Random
diffnet.toa(x) <- sample(x$toa, size = nnodes(x))

# Diffusion map (random toa)
dm1 <- diffusionMap(x, layout = dm0$coords, kde2d.args=list(n=150, h=.5))

oldpar <- par(no.readonly = TRUE)
col <- colorRampPalette(blues9)(100)
par(mfrow=c(1,2), oma=c(1,0,0,0))
image(dm0, col=col, main="Non-random Times of Adoption\\nAdoption from the core.")
image(dm1, col=col, main="Random Times of Adoption")
par(mfrow=c(1,1))
mtext("Both networks have the same distribution on times of adoption", 1,
      outer = TRUE)
par(oldpar)
}

# Example with Brazilian Farmers --------------------------------------------
\dontrun{
dn <- brfarmersDiffNet

# Setting last TOA as NA
diffnet.toa(dn)[dn$toa == max(dn$toa)] <-
  NA

# Coordinates
coords <- sna::gplot.layout.fruchtermanreingold(
  as.matrix(dn$graph[[1]]), layout.par=NULL
)

# Plotting diffusion
plot_diffnet2(dn, layout=coords, vertex.size = 300)

# Adding diffusion map
out <- diffusionMap(dn, layout=coords, kde2d.args=list(n=100, h=50))
col <- adjustcolor(colorRampPalette(c("white","lightblue", "yellow", "red"))(100),.5)
with(out$map, .filled.contour(x,y,z,pretty(range(z), 100),col))
}

}
\references{
Vega Yon, George G., and Valente, Thomas W., Visualizing Large Annotated
Networks as Heatmaps using Weighted Averages based on Kernel Smoothers (Working paper).
}
\seealso{
Other visualizations: \code{\link{dgr}},
  \code{\link{drawColorKey}},
  \code{\link{grid_distribution}},
  \code{\link{hazard_rate}}, \code{\link{plot_adopters}},
  \code{\link{plot_diffnet2}}, \code{\link{plot_diffnet}},
  \code{\link{plot_infectsuscep}},
  \code{\link{plot_threshold}},
  \code{\link{rescale_vertex_igraph}}
}
\author{
George G. Vega Yon
}
