% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-methods.R
\name{plot_diffnet}
\alias{plot_diffnet}
\title{Plot the diffusion process}
\usage{
plot_diffnet(graph, cumadopt, slices = NULL, displaylabels = FALSE,
  undirected = TRUE, vertex.col = c("grey", "red", "blue"),
  vertex.cex = "degree", label = rownames(graph[[1]]), edge.col = "gray",
  mode = "fruchtermanreingold", layout.par = NULL, mfrow.par = NULL,
  main = "Network in period \%d", mai = c(0, 0, 1, 0), mar = rep(1, 4) +
  0.1, gmode = ifelse(undirected, "graph", "digraph"), lgd = list(x =
  "center", legend = c("Non adopters", "New adopters", "Adopters"), pch = 21,
  bty = "n", cex = 1.2, horiz = TRUE), coords = NULL, ...)
}
\arguments{
\item{graph}{A dynamic graph (see \code{\link{netdiffuseR-graphs}}).}

\item{cumadopt}{\eqn{n\times T}{n*T} matrix.}

\item{slices}{Integer vector. Indicates what slices to plot. By default all are plotted.}

\item{displaylabels}{Logical scalar. When TRUE vertex labels are displayed (see \code{\link[sna:gplot]{gplot}})}

\item{undirected}{Logical scalar.}

\item{vertex.col}{A character vector of size 3 with colors names.}

\item{vertex.cex}{Numeric vector of size \eqn{n}. Size of the vertices.}

\item{label}{Character vector of size \eqn{n}. If no provided, rownames of
the graph are used.}

\item{edge.col}{Character scalar/vector. Color of the edge.}

\item{mode}{Character scalar. Name of the layout algorithm to implement (see details).}

\item{layout.par}{Layout parameters (see details).}

\item{mfrow.par}{Vector of size 2 with number of rows and columns to be passed to \code{\link{par}.}}

\item{main}{Character scalar. A title template to be passed to \code{\link{sprintf}.}}

\item{mai}{Numeric vector of size 4. To be passed to \code{\link{par}.}}

\item{mar}{Numeric vector of size 4. To be passed to \code{\link{par}.}}

\item{gmode}{Character scalar. See \code{\link[sna:gplot]{gplot}.}}

\item{lgd}{List of arguments to be passed to \code{\link{legend}}.}

\item{coords}{Numeric matrix of size \eqn{n\times 2}{n * 2} with vertices coordinates.}

\item{...}{Further arguments to be passed to \code{\link[sna:gplot]{gplot}.}}
}
\value{
Calculated coordinates for the grouped graph (invisible).
}
\description{
Creates a colored network plot showing the structure of the graph through time
(one network plot for each time period)  and the set of adopter and non-adopters
in the network.
}
\details{
Plotting is done via the function \code{\link[sna:gplot]{gplot}},
and its layout via \code{\link[sna:gplot.layout]{gplot.layout}}, both from
the (\pkg{sna}) package.

In order to center the attention on the diffusion process itself, the
positions of each vertex are computed only once by aggregating the networks
through time, this is, instead of computing the layout for each time \eqn{t},
the function creates a new graph accumulating links through time.

The \code{mfrow.par} sets how to arrange the plots on the device. If \eqn{T=5}
and \code{mfrow.par=c(2,3)}, the first three networks will be in the top
of the device and the last two in the bottom.

The argument \code{vertex.col} contains the colors of non-adopters, new-adopters,
and adopters respectively. The new adopters (default color \code{"red"}) have a different
color that the adopters when the graph is at their time of adoption, hence,
when the graph been plotted is in \eqn{t=2} and \eqn{toa=2} the vertex will
be plotted in red.

\code{vertex.cex} can either be a numeric scalar, a numeric vector or a character
scalar taking any of the following values \code{"degree"}, \code{"indegree"}, or
\code{"outdegree"}. The later will be passed to \code{\link{dgr}} to calculate
degree of the cumulated graph and will be normalized as

\deqn{vertex.cex = [d - \min(d) + .1]/[\max(d) - \min(d) + .1]\times 2}{vertex.cex = [d - min(d) + .1]/[max(d) - min(d) + .1]* 2}

where \eqn{d=\sqrt{dgr(graph)}}{d=sqrt(dgr(graph))}.
}
\examples{
# Generating a random graph
set.seed(1234)
n <- 6
nper <- 5
graph <- rgraph_er(n,nper, p=.3, undirected = FALSE)
toa <- sample(2000:(2000+nper-1), n, TRUE)
adopt <- toa_mat(toa)

plot_diffnet(graph, adopt$cumadopt)
}
\author{
George G. Vega Yon
}
\seealso{
Other visualizations: \code{\link{hazard_rate}},
  \code{\link{plot_adopters}},
  \code{\link{plot_infectsuscep}},
  \code{\link{plot_threshold}}
}
\keyword{hplot}

