% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-c.R
\name{c.diffnet}
\alias{c.diffnet}
\title{Combine diffnet objects}
\usage{
\method{c}{diffnet}(..., recursive = FALSE)
}
\arguments{
\item{...}{diffnet objects to be concatenated.}

\item{recursive}{Ignored.}
}
\value{
A new \code{diffnet} object with as many vertices as the sum of each
concatenated diffnet objects' number of vertices.
}
\description{
Combining \code{\link{diffnet}} objects that share time periods and attributes names, but
vertices ids (only valid for diffnet objects that have an empty intersection
between vertices ids)
}
\details{
The diffnet objects in \code{...} must fulfill the following conditions:
\enumerate{
 \item Have the same time range,
 \item have the same vertex attributes, and
 \item have an empty intersection of vertices ids,
}

The meta data regarding \code{undirected}, \code{value}, and \code{multiple}
are set to \code{TRUE} if any of the concatenating diffnet objects has that
meta equal to \code{TRUE}.

The resulting diffnet object's columns in the vertex attributes ordering (both
dynamic and static) will coincide with the first diffnet's ordering.
}
\examples{
# Calculate structural equivalence exposure by city -------------------------
data(medInnovationsDiffNet)

# Subsetting diffnets
city1 <- medInnovationsDiffNet[medInnovationsDiffNet[["city"]] == 1]
city2 <- medInnovationsDiffNet[medInnovationsDiffNet[["city"]] == 2]
city3 <- medInnovationsDiffNet[medInnovationsDiffNet[["city"]] == 3]
city4 <- medInnovationsDiffNet[medInnovationsDiffNet[["city"]] == 4]

# Computing exposure in each one
city1[["expo_se"]] <- exposure(city1, alt.graph="se", valued=TRUE)
city2[["expo_se"]] <- exposure(city2, alt.graph="se", valued=TRUE)
city3[["expo_se"]] <- exposure(city3, alt.graph="se", valued=TRUE)
city4[["expo_se"]] <- exposure(city4, alt.graph="se", valued=TRUE)

# Concatenating all
diffnet <- c(city1, city2, city3, city4)
diffnet


}
\seealso{
Other diffnet methods: \code{\link{as.array.diffnet}},
  \code{\link{as_diffnet}},
  \code{\link{diffnet-arithmetic}},
  \code{\link{diffnet_index}}
}

