/*
 * Decompiled with CFR 0.152.
 */
package af.statguitoolkit.gui.datawizard;

import af.statguitoolkit.gui.datawizard.DataWizard;
import af.statguitoolkit.io.datasets.RDataFrameDescriptor;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.af.commons.Localizer;
import org.af.commons.widgets.lists.MyListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelNavResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PanelRDataSet
extends WizardPage
implements ListSelectionListener,
ActionListener {
    private static final Log logger = LogFactory.getLog(PanelRDataSet.class);
    static List<String> packages = null;
    private JList liPackages = null;
    private JList liDataSets = null;
    private static Hashtable<String, List<String>> toDataSets = null;
    DataWizard wizard;
    JTextField tfPackage = new JTextField(30);
    String p = "";
    String ds = "";

    public static String getDescription() {
        return Localizer.getInstance().getString("SGTK_DATAWIZARD_PANEL_RDATA_DESC");
    }

    public PanelRDataSet(DataWizard wizard) {
        logger.debug((Object)"Constructor");
        this.wizard = wizard;
        if (packages == null || toDataSets == null) {
            packages = this.getLoadedRPackages();
            this.filterPackagesWithNoDatasets();
            this.getDataSetsFromPackages();
        }
        MyListModel modelPackages = new MyListModel(packages);
        this.liPackages = new JList(modelPackages);
        this.liPackages.setSelectionMode(0);
        this.liPackages.setSelectedIndex(0);
        this.liPackages.addListSelectionListener(this);
        this.liDataSets = new JList(new MyListModel());
        this.liDataSets.setSelectionMode(0);
        this.setDataSets();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        Box hBox = Box.createHorizontalBox();
        Localizer loc = Localizer.getInstance();
        Box vBox = Box.createVerticalBox();
        vBox.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_RDATA_PACK")));
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(new JScrollPane(this.liPackages));
        hBox.add(vBox);
        hBox.add(Box.createHorizontalGlue());
        vBox = Box.createVerticalBox();
        vBox.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_RDATA_DATASET")));
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(new JScrollPane(this.liDataSets));
        hBox.add(vBox);
        panel.add(hBox);
        String cols = "pref:grow, 5dlu, pref:grow";
        String rows = "pref:grow, 5dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        this.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        this.add(panel, cc.xyw(1, 1, 3));
        this.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_RDATA_LOADPACK")), cc.xy(1, 3));
        this.add(this.tfPackage, cc.xy(3, 3));
        this.tfPackage.addActionListener(this);
    }

    private List<String> getLoadedRPackages() {
        return null;
    }

    private List<String> getDataSetsFromPackage(String p) {
        logger.debug((Object)"getDataSetsFromPackage");
        return null;
    }

    public WizardPanelNavResult allowFinish(String stepName, Map settings, Wizard wizard) {
        logger.debug((Object)"allowFinish");
        if (this.liDataSets.getSelectedValue() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), Localizer.getInstance().getString("SGTK_DATAWIZARD_PANEL_RDATA_PLSSELECTPACK"));
            return WizardPanelNavResult.REMAIN_ON_PAGE;
        }
        String p = this.liPackages.getSelectedValue().toString();
        String ds = this.liDataSets.getSelectedValue().toString();
        logger.info((Object)("Loading data set \"" + ds + "\" from package\"" + p + "\"."));
        if (!this.p.equals(p) || !this.ds.equals(ds)) {
            this.p = p;
            this.ds = ds;
            this.wizard.dataFrameDescriptor = new RDataFrameDescriptor(ds, p);
        }
        return WizardPanelNavResult.PROCEED;
    }

    private void getDataSetsFromPackages() {
        logger.debug((Object)"getDataSetsFromPackages");
        toDataSets = new Hashtable();
        for (String p : packages) {
            toDataSets.put(p, this.getDataSetsFromPackage(p));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        logger.debug((Object)"valueChanged");
        if (!e.getValueIsAdjusting() && e.getSource() == this.liPackages) {
            this.setDataSets();
        }
    }

    private void setDataSets() {
        logger.debug((Object)"setDataSets");
        if (this.liPackages.getSelectedValue() == null) {
            return;
        }
        String selPackage = this.liPackages.getSelectedValue().toString();
        List<String> sets = toDataSets.get(selPackage);
        this.liDataSets.setModel(new MyListModel(sets));
        if (!sets.isEmpty()) {
            this.liDataSets.setSelectedIndex(0);
        }
    }

    private void filterPackagesWithNoDatasets() {
        logger.debug((Object)"filterPackagesWithNoDatasets");
        ArrayList<String> result = new ArrayList<String>();
        for (String p : packages) {
            if (this.getDataSetsFromPackage(p).size() <= 0) continue;
            result.add(p);
        }
        packages = result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)"actionPerformed");
        if (e.getSource().equals(this.tfPackage)) {
            String pckg = this.tfPackage.getText();
            Boolean loaded = null;
            loaded = false;
            if (loaded == null || !loaded.booleanValue()) {
                JOptionPane.showMessageDialog((Component)((Object)this), Localizer.getInstance().getString("SGTK_DATAWIZARD_PANEL_RDATA_ERRLOADPACK") + "\n" + pckg);
            } else {
                ((MyListModel)this.liPackages.getModel()).addElement((Object)pckg);
                toDataSets.put(pckg, this.getDataSetsFromPackage(pckg));
            }
            this.tfPackage.setText("");
        }
    }
}

