/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.af.commons.widgets.buttons.OkCancelButtonPane;
import org.af.commons.widgets.validate.RealTextField;
import org.af.commons.widgets.validate.ValidationException;
import org.mutoss.MuTossControl;

public class AlphaDialog
extends JDialog
implements ActionListener {
    RealTextField tfAlpha;
    String type;
    String selected = null;

    public AlphaDialog(JFrame parent) {
        this(parent, "Set Alpha");
    }

    public AlphaDialog(JFrame parent, String type) {
        super(parent, type, true);
        this.type = type;
        this.createContent();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.getContentPane().setLayout(new GridBagLayout());
        String label = null;
        if (type.equals("FWER")) {
            label = "Family wise error rate alpha";
        }
        if (type.equals("GFWER")) {
            label = "Generalized family wise error rate alpha";
        }
        if (type.equals("FDR")) {
            label = "False discovery rate alpha";
        }
        this.getContentPane().add((Component)new JLabel(label), c);
        ++c.gridx;
        this.getContentPane().add((Component)this.tfAlpha, c);
        ++c.gridy;
        c.gridx = 0;
        OkCancelButtonPane buttonPane = new OkCancelButtonPane();
        buttonPane.addActionListener((ActionListener)this);
        c.gridwidth = 2;
        this.getContentPane().add((Component)buttonPane, c);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void createContent() {
        this.tfAlpha = new RealTextField("alpha", 0.0, 1.0);
        this.tfAlpha.setText("0.05");
    }

    public String getSelected() {
        return this.selected;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            try {
                Double alpha = (Double)this.tfAlpha.getValidatedValue();
                MuTossControl.getObj().setAlpha(this.type, alpha);
                this.dispose();
            }
            catch (ValidationException e1) {
                JOptionPane.showMessageDialog(this.getParent(), "You have to choose an error rate between 0 and 1.", "No valid error rate", 0);
            }
        } else if (e.getActionCommand().equals("CANCEL")) {
            this.dispose();
        }
    }
}

