% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_distribution.R
\name{COM_Poisson_Distribution}
\alias{COM_Poisson_Distribution}
\alias{dcomp}
\alias{pcomp}
\alias{qcomp}
\alias{rcomp}
\title{The Conway-Maxwell-Poisson (COM-Poisson) Distribution.}
\usage{
dcomp(
  x,
  mu,
  nu = 1,
  lambda,
  log.p = FALSE,
  lambdalb = 1e-10,
  lambdaub = 1000,
  maxlambdaiter = 1000,
  tol = 1e-06,
  summax
)

pcomp(
  q,
  mu,
  nu = 1,
  lambda,
  lower.tail = TRUE,
  log.p = FALSE,
  lambdalb = 1e-10,
  lambdaub = 1000,
  maxlambdaiter = 1000,
  tol = 1e-06,
  summax
)

qcomp(
  p,
  mu,
  nu = 1,
  lambda,
  lower.tail = TRUE,
  log.p = FALSE,
  lambdalb = 1e-10,
  lambdaub = 1000,
  maxlambdaiter = 1000,
  tol = 1e-06,
  summax
)

rcomp(
  n,
  mu,
  nu = 1,
  lambda,
  lambdalb = 1e-10,
  lambdaub = 1000,
  maxlambdaiter = 1000,
  tol = 1e-06,
  summax
)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu, nu}{mean and dispersion parameters. Must be strictly positive.}

\item{lambda}{an alternative way than mu to parametrized the distribution.
Must be strictly positive}

\item{log.p}{logical; if \code{TRUE}, probabilities/densities \eqn{p} are returned as
\eqn{log(p)}.}

\item{lambdalb, lambdaub}{numeric: the lower and upper end points for the interval to be
searched for lambda(s).}

\item{maxlambdaiter}{numeric: the maximum number of iterations allowed to solve
for lambda(s).}

\item{tol}{numeric: the convergence threshold. A lambda is said to satisfy the
mean constraint if the absolute difference between the calculated mean and mu
is less than tol.}

\item{summax}{numeric; maximum number of terms to be considered in the truncated sum.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are \eqn{P(X \le x)},
otherwise, \eqn{P(X>x)}.}

\item{p}{vector of probabilities}

\item{n}{number of observations. If \code{length(n)} > 1, the length is taken to
be the number required.}
}
\value{
\code{dcomp} gives the density, \code{pcomp} gives the distribution function, \code{qcomp} gives the quantile function, and \code{rcomp} generates random deviates.

Invalid arguments will result in return value \code{NaN}, with a warning.

The length of the results is determined by \code{n} for \code{rcomp}, and is the maximum
of the lengths of the numerical arguments for the other functions.

The numerical arguments other than \code{n} are recycled to the length of the results.
Only the first argument of the logical arguments are used.
}
\description{
Density, distribution function, quantile function and random generation for the
Conway-Maxwell-Poisson distribution with parameter \code{mu} and \code{nu}
}
\examples{
dcomp(0:5, mu = 2, nu = 1.2)
pcomp(5, mu=2, nu =1.2)
p <- (1:9)/10
qcomp(p, mu = 2, nu = 0.8)
rcomp(10, mu = 2, nu = 0.7)
}
