% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_related.R
\name{PIT_Plot}
\alias{PIT_Plot}
\alias{histcompPIT}
\alias{qqcompPIT}
\title{PIT Plots for a CMP Object}
\usage{
histcompPIT(object, bins = 10, line = TRUE, colLine = "red",
  colHist = "royal blue", lwdLine = 2, main = NULL, ...)

qqcompPIT(object, bins = 10, col1 = "red", col2 = "black",
  lty1 = 1, lty2 = 2, type = "l", main = NULL, ...)
}
\arguments{
\item{object}{an object class "cmp", obtained from a call to \code{glm.cmp}.}

\item{bins}{numeric; the number of bins shown in the PIT histogram or the 
PIT Q-Q plot.}

\item{line}{logical; if \code{TRUE} (default), the line for displaying the standard 
uniform distribution will be shown for the purpose of comparison.}

\item{colLine}{numeric or charater: the colour of the line for comparison 
in PIT histogram.}

\item{colHist}{numeric or character; the colour of the histogram for PIT.}

\item{lwdLine}{numeric; the line widths for the comparison line in PIT histogram.}

\item{main}{character string; a main title for the plot.}

\item{...}{other arguments passed to plot.default and plot.ts.}

\item{col1}{numeric or character; the colour of the sample uniform Q-Q plot in PIT.}

\item{col2}{numeric or character; the colour of the theoretical uniform Q-Q plot in PIT.}

\item{lty1}{integer or character string: the line types for the sample 
uniform Q-Q plot in PIT, see par(lty = .).}

\item{lty2}{an integer or character string: the line types for the theoretical uniform 
Q-Q plot in PIT, see par(lty = .).}

\item{type}{1-character string; the type of plot for the sample uniform Q-Q plot in PIT.}
}
\description{
Two plots for the non-randomized PIT are currently available for checking the 
distributional assumption of the fitted CMP model: the PIT histogram, and 
the uniform Q-Q plot for PIT.
}
\details{
The histogram and the Q-Q plot are used to compare the fitted profile with a standard
uniform distribution. If they match relatively well, it means the CMP distribution 
is appropriate for the data.
}
\examples{
## For examples see example(plot.cmp)
}
\references{
Czado, C., Gneiting, T. and Held, L. (2009). Predictive model assessment
for count data. \emph{Biometrics}, \strong{65}, 1254--1261.

Dunsmuir, W.T.M. and Scott, D.J. (2015). The \code{glarma} Package for Observation-Driven
Time Seires Regression of Counts. \emph{Journal of Statistical Software}, 
\strong{67}, 1--36.
}
