% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export}
\alias{export}
\title{Export mechanism for modules}
\usage{
export(..., where = parent.frame())
}
\arguments{
\item{...}{(character, or unquoted expression) names to export from module. A
character of length 1 with a leading "^" is interpreted as regular
expression.}

\item{where}{(environment) typically the calling environment. Should only be
relevant for testing.}
}
\description{
You can declare exports very much like the export mechanism in R packages: you
define which objects from the module you make available to a user. All other
objects are kept private, local, to the module.
}
\details{
A module can have several export declarations, e.g. directly in
front of each function definition. That means: exports stack up. When you
supply a regular expression, however, only one export pattern should be
declared. A regular expression is denoted, as a convention, as character
vector of length one with a leading "^".
}
\examples{
module({
  export("foo")
  foo <- function() "foo"
  bar <- function() "bar"
})

module({
  export("foo")
  foo <- function() "foo"
  export("bar")
  bar <- function() "bar"
})

module({
  export("foo", "bar")
  foo <- function() "foo"
  bar <- function() "bar"
})

module({
  export("^f.*$")
  foo <- function() "foo"
  bar <- function() "bar"
})

}
