% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothing.R
\name{smoothing}
\alias{smoothing}
\title{Smoothing a vector or a time series}
\usage{
smoothing(x, method = "loess", strength = 0.25, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{method}{Can be \link[=loess]{"loess"} (default) or
\link[=smooth]{"smooth"}. A loess smoothing can be slow.}

\item{strength}{This argument only applies when \code{method = "loess"}.
Degree of smoothing passed to \code{span} (see \code{\link{loess}}).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A smoothed vector or data frame.
}
\description{
Smoothing a vector or a time series. For data.frames, the function will
smooth all numeric variables stratified by factor levels (i.e., will smooth
within each factor level combination).
}
\examples{
x <- sin(seq(0, 4 * pi, length.out = 100)) + rnorm(100, 0, 0.2)
plot(x, type = "l")
lines(smoothing(x, method = "smooth"), type = "l", col = "blue")
lines(smoothing(x, method = "loess"), type = "l", col = "red")

x <- sin(seq(0, 4 * pi, length.out = 10000)) + rnorm(10000, 0, 0.2)
plot(x, type = "l")
lines(smoothing(x, method = "smooth"), type = "l", col = "blue")
lines(smoothing(x, method = "loess"), type = "l", col = "red")
}
