% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_response.frequentist.R
\name{estimate_response.glm}
\alias{estimate_response.glm}
\alias{estimate_link.glm}
\title{Generates predictions for Frequentist models}
\usage{
\method{estimate_response}{glm}(
  model,
  data = NULL,
  transform = "response",
  include_smooth = TRUE,
  include_random = TRUE,
  length = 25,
  preserve_range = TRUE,
  predict = "response",
  ci = 0.95,
  ...
)

\method{estimate_link}{glm}(
  model,
  data = "grid",
  transform = "response",
  include_smooth = TRUE,
  include_random = FALSE,
  length = 25,
  preserve_range = TRUE,
  predict = "link",
  ci = 0.95,
  ...
)
}
\arguments{
\item{model}{A statistical model.}

\item{data}{A data frame with model's predictors to estimate the response. If NULL, the model's data is used. If "grid", the model matrix is obtained (through \code{\link{visualisation_matrix}}).}

\item{transform}{Can be \code{"none"} (default for contrasts), \code{"response"} (default for means), \code{"mu"}, \code{"unlink"}, \code{"log"}. \code{"none"}  will leave the values on scale of the linear predictors. \code{"response"} will transform them on scale of the response variable. Thus for a logistic model, \code{"none"} will give estimations expressed in log-odds (probabilities on logit scale) and \code{"response"} in terms of probabilities.}

\item{include_smooth}{Should the smooth terms (in General Additive Models - GAM) be included?}

\item{include_random}{Should it take the random effects into account? Can be \code{TRUE}, \code{FALSE} or a formula indicating which group-level parameters to condition on when making predictions. The data argument may include new levels of the grouping factors that were specified when the model was estimated, in which case the resulting posterior predictions marginalize over the relevant variables (see \code{posterior_predict.stanreg}).}

\item{length}{Passed to \code{\link{visualisation_matrix}} if \code{data = "grid"}.}

\item{preserve_range}{Passed to \code{\link{visualisation_matrix}} if \code{data = "grid"}.}

\item{predict}{Can be "response" (default) or "link". The former predicts the the outcome per se, while the latter predicts the link function (i.e., the regression "line"), equivalent to estimating the \code{fit}. In other words, \code{estimate_response(model, predict="link")} is equivalent to \code{estimate_link(model)}.}

\item{ci}{Credible Interval (CI) level. Default to 0.89 (89\%). See \code{\link[bayestestR]{ci}} for further details.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A dataframe of predicted values.
}
\description{
Generates predictions for Frequentist models
}
\examples{
library(modelbased)

model <- lm(Sepal.Width ~ Species * Petal.Length, data = iris)
estimate_response(model)
estimate_link(model)

if (require("lme4")) {
  model <- lmer(Sepal.Width ~ Petal.Length + (1 | Species), data = iris)
  estimate_response(model)
  estimate_link(model)
}
}
