% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRcol.R
\name{LRcol}
\alias{LRcol}
\title{Likelihood ratio for color variable}
\usage{
LRcol(
  MPc = 1,
  epc = Cmodel(),
  erRc = epc,
  nsims = 1000,
  Pc = c(0.3, 0.2, 0.25, 0.15, 0.1),
  H = 1,
  Qprop = MPc,
  LR = FALSE,
  seed = 1234
)
}
\arguments{
\item{MPc}{MP hair color}

\item{epc}{epsilon paramenter.}

\item{erRc}{error rate in the database.}

\item{nsims}{number of simulations performed.}

\item{Pc}{hair color probabilities.}

\item{H}{hypothesis tested, H1: UHR is MP, H2: UHR is no MP}

\item{Qprop}{Query color tested.}

\item{LR}{compute LR values}

\item{seed}{For reproducible simulations}
}
\value{
A value of Likelihood ratio based on preliminary investigation data. In this case, hair color.
}
\description{
Likelihood ratio for color variable
}
\examples{
LRcol() 
}
