% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primers.R
\name{amplicon}
\alias{amplicon}
\title{Primer matching}
\usage{
amplicon(dna, forward, reverse)
}
\arguments{
\item{dna}{Character vector containing the DNA sequences.}

\item{forward}{String specifying the forward primer.}

\item{reverse}{String specifying the reverse primer.}
}
\value{
A list with the same number of elements as the argument \code{dna}. Each list element
contains a string vector with all amplicons resulting from the primer matching. If there is no
primer pair match the corresponding string vector is empty.
}
\description{
Extracts subsequences from DNA that matches a specified primer pair.
}
\details{
An amplicon is a subsequence limited by a matching pair of short oligos, called primers.

The \code{forward} primer is a short DNA sequence in the 5' to 3' direction. This can match on both strands of
the \code{dna} sequence. The \code{reverse} primer is also a short DNA sequence in 5' to 3' direction, and
can also match on both strands of \code{dna}.

For a \code{dna} sequence to produce an amplicon there must be an exact match of the \code{forward}
on one strand followed by an exact match of the \code{reverse} on the other strand. The amplicon is
the subsequence starting with the \code{forward} and ending with the \code{reverse} primer.

Both primers may contain ambiguity symbols according to the IUPAC standard. 
Primers are matched by \code{\link{gregexpr}}, which will not register self-overlapping matches. 
In case of multiple (non-overlapping) matches, this function will return all possible amplicons resulting 
from the primer matching.
}
\examples{
ex.file <- file.path(file.path(path.package("microseq"),"extdata"),"small.fasta")
fdta <- readFasta(ex.file)
amp.lst.1 <- amplicon( fdta$Sequence, forward="AAATTC", reverse="CCAGA" )
amp.lst.2 <- amplicon( fdta$Sequence, forward="AANNTC", reverse="CCNGT" ) # more matches due to N's

}
\author{
Lars Snipen.
}

