% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkFunctions.R
\name{plotMMCurve}
\alias{plotMMCurve}
\title{plot Michealis-Menten curve for either capacity dependent absorption or clearance}
\usage{
plotMMCurve(dataInput, parameter)
}
\arguments{
\item{dataInput}{output of function \code{\link{getMMCurve}}}

\item{parameter}{character value indicating either \code{absorption} or \code{clearance}}
}
\value{
ggplot2-object
}
\description{
plot Michealis-Menten curve for either capacity dependent absorption or clearance
}
\examples{
  plotMMCurve( dataInput = getMMCurve( seq(0, 5 , 0.01 ) ,
      Vmax = 5 , kappaMM = 0.3 ) , parameter = "absorption" )
  plotMMCurve( dataInput = getMMCurve( seq(0, 5 , 0.01 ) ,
      Vmax = 5 , kappaMM = 0.3 , constantValue = 4 ) , parameter = "absorption" ) 
  plotMMCurve( dataInput = getMMCurve( seq(0, 1 , 0.01 ) ,
      Vmax = 2 , kappaMM = 0.3 ) , parameter = "clearance" )
  plotMMCurve( dataInput = getMMCurve( seq(0, 1 , 0.01 ) ,
       Vmax = 2 , kappaMM = 0.3 , constantValue = 1.5 ) , parameter = "clearance" )  
}
