% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_previz.R
\name{st_previz}
\alias{st_previz}
\title{Process the \code{\link[=stabilitas]{stabilitas()}} output to a new format ready for the visualization functions.}
\usage{
st_previz(results, times)
}
\arguments{
\item{results}{a list with the \code{\link[=stabilitas]{stabilitas()}} outputs.}

\item{times}{a vector with the names of each paired time, e.g. "t1_t2".}
}
\value{
A data frame ready for its use under the visualization functions.
}
\description{
Process the \code{\link[=stabilitas]{stabilitas()}} output to a new format ready for the visualization functions.
}
\examples{
t1_t2 <- paired_times(data = clr[,1:25], first = "_1",
                      second = "_25", common = "_0_")
t2_t3 <- paired_times(data = clr[,1:25], first = "_25",
                      second = "_26", common = "_0_")
klist_t1_t2 <- iterative_clustering(data = t1_t2, parallel = FALSE)
klist_t2_t3 <- iterative_clustering(data = t2_t3, parallel = FALSE)
result_t1_t2 <- stabilitas(klist_t1_t2, common = "_0_")
result_t2_t3 <- stabilitas(klist_t2_t3, common = "_0_")
results <- st_previz(results = list(result_t1_t2, result_t2_t3),
                     times = c("t1_t2", "t2_t3"))
}
