% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_groups.R
\name{metadata_groups}
\alias{metadata_groups}
\title{Easily extract groups of individuals from metadata variables.}
\usage{
metadata_groups(metadata, samples, individuals, col_number)
}
\arguments{
\item{metadata}{data frame with one column of samples matching with the rownames of the original input matrix to \code{\link[=paired_times]{paired_times()}}.}

\item{samples}{vector from metadata corresponding to the samples ID.}

\item{individuals}{vector of individuals located in the first column of the \code{\link[=st_previz]{st_previz()}} output.}

\item{col_number}{number of the column with the variable used for grouping individuals.}
}
\value{
A vector with the same length as the number of rows in the \code{\link[=st_previz]{st_previz()}} output.
}
\description{
Easily extract groups of individuals from metadata variables.
}
\examples{
t1_t2 <- paired_times(data = clr[,1:25], first = "_1",
                      second = "_25", common = "_0_")
t2_t3 <- paired_times(data = clr[,1:25], first = "_25",
                      second = "_26", common = "_0_")
klist_t1_t2 <- iterative_clustering(data = t1_t2, parallel = FALSE)
klist_t2_t3 <- iterative_clustering(data = t2_t3, parallel = FALSE)
result_t1_t2 <- stabilitas(klist_t1_t2, common = "_0_")
result_t2_t3 <- stabilitas(klist_t2_t3, common = "_0_")
results <- st_previz(results = list(result_t1_t2, result_t2_t3),
                     times = c("t1_t2", "t2_t3"))
metadata <- data.frame(Sample = rownames(clr),
                       age = c(rep("youth", 65), rep("old", 131-65)))
group <- metadata_groups(metadata = metadata, samples = metadata$Sample,
                         individuals = results$individual, col_number = 2)
}
