% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primersearch.R
\name{run_primersearch}
\alias{run_primersearch}
\title{Execute EMBOSS Primersearch}
\usage{
run_primersearch(seq_path, primer_path, mismatch = 5,
  output_path = tempfile(), program_path = "primersearch", ...)
}
\arguments{
\item{seq_path}{A character vector of length 1. The path to the fasta file containing reference
sequences to search for primer matches in.}

\item{primer_path}{A character vector of length 1. The path to the file containing primer pairs
to match. The file should be whitespace-delimited with 3 columns: primer name, first primer
sequence, and second primer sequence.}

\item{mismatch}{An integer vector of length 1. The percentage of mismatches allowed.}

\item{output_path}{A character vector of length 1. Where the output of primersearch is saved.}

\item{program_path}{A character vector of length 1. The location of the primersearch binary.
Ideally, it should be in your system's search path.}

\item{...}{Additional arguments are passed to \code{primersearch}.}
}
\value{
The command generated as a character vector of length 1.
}
\description{
Execute EMBOSS Primersearch
}
\seealso{
\code{\link{parse_primersearch}}
}
\keyword{internal}
