% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_stand_MD.R
\name{es_from_md_se}
\alias{es_from_md_se}
\title{Convert a mean difference between two independent groups and its standard error into several effect size measures}
\usage{
es_from_md_se(md, md_se, n_exp, n_nexp, smd_to_cor = "viechtbauer", reverse_md)
}
\arguments{
\item{md}{mean difference between two independent groups}

\item{md_se}{standard error of the mean difference}

\item{n_exp}{number of participants in the experimental/exposed group.}

\item{n_nexp}{number of participants in the non-experimental/non-exposed group.}

\item{smd_to_cor}{formula used to convert the \code{cohen_d} value into a coefficient correlation (see details).}

\item{reverse_md}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab MD + D + G\cr
\tab \cr
\code{converted effect size measure} \tab OR + R + Z\cr
\tab \cr
\code{required input data} \tab See 'Section 10. Mean difference and dispersion (crude)'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert a mean difference between two independent groups and its standard error into several effect size measures
}
\details{
This function the standard error of a mean difference into a
standard deviation:
\deqn{inv\_n = \frac{1}{n\_exp} + \frac{1}{n\_nexp}}
\deqn{md\_sd = \frac{md\_se}{\sqrt{inv\_n}}}

Calculations of the \code{\link{es_from_md_sd}} function are then used to estimate
the Cohen's d and other effect size measures.
}
\examples{
es_from_md_se(md = 4, md_se = 2, n_exp = 20, n_nexp = 22)
}
\references{
Higgins JPT, Li T, Deeks JJ (editors). Chapter 6: Choosing effect size measures and computing estimates of effect. In: Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). Cochrane Handbook for Systematic Reviews of Interventions version 6.3 (updated February 2022). Cochrane, 2022. Available from www.training.cochrane.org/handbook.
}
