% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kth.R
\name{kth}
\alias{kth}
\title{kth}
\usage{
kth(
  x = NULL,
  k = 2,
  highest = TRUE,
  index = FALSE,
  unique = FALSE,
  multiple = FALSE
)
}
\arguments{
\item{x}{Numeric vector.}

\item{k}{Positive integer. The order of the value to find. Default = 2,
which means that the next highest/lowest values is identified.}

\item{highest}{Logical. TRUE means that the kth highest value(s) is/are
identified. FALSE means that the kth lowest value(s) is/are identified.
Default = TRUE.}

\item{index}{Logical. TRUE means that the index/indices of the kth highest/lowest
value(s) is/are returned. FALSE means that the kth highest/lowest value
itself is returned. If ties exist and argument multiple = TRUE, the returned value is a vector, else
it is a value. Default=FALSE.}

\item{unique}{Logical. TRUE means that duplicates are removed before the
identification of the kth highest/lowest value(s). Default=FALSE}

\item{multiple}{Logical. TRUE means that, If ties exist a vector of
all values in x that are equal to the kth highest/lowest values is returned.
FALSE means that one random value from the vector of index values is
returned. Default=FALSE}
}
\value{
If index = FALSE: the kth highest/lowest value is returned.

        If index = TRUE: the index of the kth highest/lowest value (s) is/are
        returned.
}
\description{
Identification of the kth highest/lowest value(s).
}
\details{
NA values are removed.
}
\examples{
kth(x=1:20, k=3, highest=FALSE)

}
