% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_manual.R
\name{remove_manual}
\alias{remove_manual}
\title{Manually remove a linkage group within a specific map and update man networks and minimum spanning tree}
\usage{
remove_manual(MF.obj, to_remove)
}
\arguments{
\item{MF.obj}{A mapfuser object genetics maps after map_orient() has been performed}

\item{to_remove}{A list of linkage group ID's to remove}
}
\value{
The input object is returned in which the linkage group ID have been removed. Manually removed linkage group ID are saved to the removed_LGIDs config slot
}
\description{
The quality control passed list of genetic maps may be manually curated further with remove_manual() when the map merging process identified a linkage group witihn a map that gives a high Root Mean Square Error.
In the case of interspecific crosses one complete map could be better to exclude all together.
}
\examples{
fpath <- system.file("extdata", package="mapfuser")
maps <- list.files(fpath, pattern = "-1", full.names = TRUE)
MF.obj <- read_maps(mapfiles = maps, sep = ",", header = TRUE, type = "delim")
MF.obj <- map_qc(MF.obj)
## Remove two linkage groups manually
to_remove <- c("Col-0_Blh-1.csv_1","Col-0_Blh-1.csv_2" )
MF.obj <- remove_manual(MF.obj, to_remove)
}
\author{
Dennis van Muijen
}
