% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_export.R
\name{map_export}
\alias{map_export}
\title{Convert a consensus genetic map created with mapfuser to JoinMap format}
\usage{
map_export(MF.obj, file = NULL)
}
\arguments{
\item{MF.obj}{The mapfuser object with filled results slot}

\item{file}{Path to the output file}
}
\description{
Writes the consensus map to the JoinMap ".map" format
}
\examples{
\dontshow{
fpath <- system.file("extdata", package="mapfuser")
maps <- list.files(fpath, pattern = "-1", full.names = TRUE)
MF.obj <- read_maps(mapfiles = maps, sep = ",", header = TRUE, type = "delim")
MF.obj <- map_qc(MF.obj)
MF.obj$config$chr <- "1"
MF.obj <- LPmerge_par(MF.obj = MF.obj, n.cores = 1,
max.interval = 1, max.int_sel = "auto", weights = NULL)
file <- paste(tempdir(), "/consensus.map", sep="")
map_export(MF.obj, file)
}
\dontrun{
## Read maps
fpath <- system.file("extdata", package="mapfuser")
maps <- list.files(fpath, pattern = "Col", full.names = TRUE)
MF.obj <- read_maps(mapfiles = maps, sep = ",", header = TRUE,
mapweights = rep(1,7), type = "delim")

## Run map_qc
MF.obj <- map_qc(MF.obj, anchors = 3)

## Construct consensus map
MF.obj <- LPmerge_par(MF.obj = MF.obj, n.cores = 2,
max.interval = 1:3, max.int_sel = "auto", weights = NULL)

## Export to JoinMap format
file <- paste(tempdir(), "/consensus.map", sep="")
map_export(MF.obj, file)
}
}
\author{
Dennis van Muijen
}
