% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopFuns.R
\name{se_sig}
\alias{se_sig}
\title{Calculate One-Sided Confidence Level (\%)}
\usage{
se_sig(muvari)
}
\arguments{
\item{muvari}{Numeric array, of mean (location) values, variances corresponding to each \code{mu} to test against zero.}
}
\value{
A numeric vector of confidence levels (0-100\%), each rounded to one decimal place.
}
\description{
Computes the one-sided confidence level, defined as (1 - p-value) x 100, for testing whether each mean (\code{mu}) differs from zero under a normal approximation.
}
\details{
For each element:
\enumerate{
\item Calculate the standard error:
se = sqrt(vari).
\item Compute the absolute z-score:
z = abs(mu / se).
\item The one-sided p-value is 1 - phi(z), where phi is the CDF of the standard normal.
\item The confidence level is (1 - p-value) x 100 = phi(z) x 100.
}
}
\examples{
# Single value
se_sig(muvari = cbind(2,1))

# Vector of values
se_sig(muvari = cbind(c(-1, 0, 1),c(1, 2, 3)))

}
