% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive-ggproto.R
\name{interactivity}
\alias{interactivity}
\title{Modify the \code{interactivity} component}
\usage{
interactivity(
  linkingGroup = NULL,
  linkingKey = NULL,
  linkedStates = NULL,
  sync = NULL,
  active = NULL,
  activeGeomLayers = NULL,
  selected = NULL,
  selectBy = NULL,
  selectionLogic = NULL,
  layerId = NULL,
  scaleToFun = NULL,
  itemLabel = NULL,
  showItemLabels = NULL,
  ...
)
}
\arguments{
\item{linkingGroup}{The string identifying the group of linked plots that the current plot will join.  Default is none.}

\item{linkingKey}{The length \code{n} character vector of unique keys.  Default will be \code{"0", "1", ..., "n-1"}
where \code{n} is the number of elements (e.g., points) displayed.}

\item{linkedStates}{The character vector of display states to be linked.
These can be "color", "selected", "active", "size" and "glyph" for an `l_plot` object and
"color", "selected", "active" for an `l_hist` object.  (These roughly correspond to aesthetics in a `ggplot`.)}

\item{sync}{Either \code{"pull"} (the default) or \code{"push"} to indicate whether the values of the linked states of the plot
are to be pulled from those of the other plots in the linking group, or the values are to be pushed to all other plots
in the linking group. This matters only when joining an existing group of plots and the default value is typically
the right thing to do.}

\item{active}{a logical or a logical vector of length \code{n} that determines which observations
are active (\code{TRUE} and hence appear in the plot) and which are inactive (\code{FALSE} and hence do not appear).
Default is \code{TRUE}.}

\item{activeGeomLayers}{determine which geom layer is interactive by its `geom_...` position in the grammar of the expression.
Currently, only \code{geom_point()} and \code{geom_histogram()} can be set as the active geom layer(s) so far.
(N.B. more than one \code{geom_point()} layer can be set as an active layer,
but only one \code{geom_histogram()} can be set as an active geom layer and it can be the only active layer.)}

\item{selected}{a logical or a logical vector of length \code{n} that determines which observations
are selected (\code{TRUE} and hence appear highlighted in the plot) and which are not.
Default is \code{FALSE} and no points are highlit.}

\item{selectBy}{A string determining how selection will occur in the interactive plot.
Default is \code{"sweeping"} where a rectangular region is reshaped or "swept" out to select observations.; alternately
 \code{"brushing"} will indicate that a fixed rectangular region is moved about the display to select observations.}

\item{selectionLogic}{One of "select" (the default), "deselect", and "invert".
The first highlights observations as selected, the second downlights them, and the third inverts them (downlighting
highlit observations and highlighting downlighted ones).}

\item{layerId}{numerical; which layer to scale to}

\item{scaleToFun}{scale to function. See \code{\link{zoom}}.}

\item{itemLabel}{A character vector of length \code{n} with a string to be used to pop up when the
mouse hovers above that element.}

\item{showItemLabels}{A single logical value: \code{TRUE} if pop up labels are to appear on hover,
\code{FALSE} (the default) if they are not.}

\item{...}{named arguments to modify \code{loon} plot states. See \code{\link{l_info_states}}}
}
\value{
a \code{ggproto} object
}
\description{
Set interactive components (e.g. \code{linking}, \code{selection}, etc)
}
\details{
In interactive graphics, there are several fundamental infrastructures, such as querying, linking and selection.
Component \code{interactivity} is used to set these features.
\tabular{lll}{ \strong{Interactivity} \tab \strong{Description} \tab \strong{Subfunction}\cr
  Linking \tab Linking several plots to discover the pattern of interest \tab \code{\link{linking}}\cr
  Selection \tab Highlight the subset of interest \tab \code{\link{selection}}\cr
  Active \tab Determine which points appear \tab \code{\link{active}}\cr
  Hover \tab Query in interactive graphics \tab \code{\link{hover}}\cr
  Zoom \tab Region Modification \tab \code{\link{zoom}}\cr}
}
\examples{
if(interactive()) {
  # Modify the 'linkingGroup' and 'origin' of a hist object
  l_ggplot(mtcars, mapping = aes(x = wt)) +
    geom_histogram() +
    interactivity(linkingGroup = "mt", origin = 2)

  # linking with the histogram
  l_ggplot(mtcars, mapping = aes(x = wt, y = hp)) +
    geom_point(size = 4) +
    interactivity(linkingGroup = "mt") +
    facet_wrap(~cyl)

  p <- ggplot(economics_long, aes(value)) +
         facet_wrap(~variable, scales = 'free_x') +
         geom_histogram()
  # `p` is a ggplot object
  p
  # turn static `ggplot` to interactive `loon`
  p + interactivity()
}
}
