% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive-ggproto.R
\name{selection}
\alias{selection}
\title{Modify the \code{selected} component}
\usage{
selection(selected = NULL, selectBy = NULL, selectionLogic = NULL)
}
\arguments{
\item{selected}{a logical or a logical vector of length \code{n} that determines which observations
are selected (\code{TRUE} and hence appear highlighted in the plot) and which are not.
Default is \code{FALSE} and no points are highlit.}

\item{selectBy}{A string determining how selection will occur in the interactive plot.
Default is \code{"sweeping"} where a rectangular region is reshaped or "swept" out to select observations.; alternately
 \code{"brushing"} will indicate that a fixed rectangular region is moved about the display to select observations.}

\item{selectionLogic}{One of "select" (the default), "deselect", and "invert".
The first highlights observations as selected, the second downlights them, and the third inverts them (downlighting
highlit observations and highlighting downlighted ones).}
}
\value{
a \code{ggproto} object
}
\description{
Set which elements (i.e., observations) are "selected".  These will be shown as highlighted in the
plot using the current "highlight" colour (see \code{\link{l_userOptions}}).
}
\details{
There are two ways to directly select elements on, for example, a scatterplot using the mouse:
either by "sweeping" or by "brushing". "Sweeping" allows us to sweep out a contiguous rectangular area of the plot,
while, by "brushing", a fixed rectangular area is brushes across the plot selecting all points within the rectangle.

The selection logic give users more flexibility to users to not only highlight the elements,
but also to downlight, and even to invert selections (changing the highlighted to downlighted, and vice versa).
}
\examples{
if(interactive()) {

  # highlight the four gear cars
  fourGear <- rep(FALSE, nrow(mtcars))
  fourGear[mtcars$gear == 4] <- TRUE

  l_ggplot(mtcars, mapping = aes(x = wt, y = hp, color = factor(cyl))) +
    geom_point(size = 4) +
    # push the states of scatter plot to the histogram
    selection(selected = fourGear)
}
}
\seealso{
\code{\link{active}}, \code{\link{linking}}, \code{\link{zoom}},
\code{\link{hover}}, \code{\link{interactivity}}, \code{\link{l_userOptions}}
}
