% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance_sampling.R
\name{importance_sampling}
\alias{importance_sampling}
\title{A parent class for different importance sampling methods.}
\usage{
importance_sampling(log_ratios, method, ...)
}
\arguments{
\item{log_ratios}{An array, matrix, or vector of importance ratios on the log
scale (for PSIS-LOO these are \emph{negative} log-likelihood values). See the
\strong{Methods (by class)} section below for a detailed description of how
to specify the inputs for each method.}

\item{method}{The importance sampling method to use. The following methods
are implemented:
\itemize{
\item \code{\link[=psis]{"psis"}}: Pareto-Smoothed Importance Sampling (PSIS). Default method.
\item \code{\link[=tis]{"tis"}}: Truncated Importance Sampling (TIS) with truncation at
\code{sqrt(S)}, where \code{S} is the number of posterior draws.
\item \code{\link[=sis]{"sis"}}: Standard Importance Sampling (SIS).
}}

\item{...}{Arguments passed on to the various methods.}
}
\description{
A parent class for different importance sampling methods.
}
\keyword{internal}
