% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.tools.R
\name{deleting_wrongeffect}
\alias{deleting_wrongeffect}
\title{check monotonicity of marginal impacts and re-estimate the model.}
\usage{
deleting_wrongeffect(model, focus_var_raw = NULL, focus_var_model = NULL,
  Monoton_to_Match = 1, family = NULL, re_estimate = TRUE, data,
  STOP = FALSE, PRINT = TRUE, PLOT = TRUE, ...)
}
\arguments{
\item{model, }{an output of lm or glm}

\item{focus_var_raw}{see \code{\link{effects}}.}

\item{focus_var_model}{see \code{\link{effects}}.}

\item{Monoton_to_Match}{1 or -1. 1 means you want monotonic increasing as the correct marginal effect, -1 means negative}

\item{family}{family of glm, for example, can be gaussian \code{"(link = 'identity')"}  or \code{"(link = 'logit')"}.
If NULL, we will use the default family of the model}

\item{re_estimate}{a boolean with default as TRUE. This is to decide
if the marginal impacts are found to be incorrect, then whether to delete a model var that
potentially cause the wrong marginal impacts and re-estimate the model}

\item{data}{optional, a new dataset to show the marginal impacts and re-estimate the model.
If NULL, then use the data used in model itself.}

\item{STOP}{a boolean. When find a model with incorrect marginal impacts, whether to stop there and wait to continue (call the \code{\link{Enter_to_Continue}})}

\item{PRINT}{a boolean, whether to print messages and to plot.}

\item{PLOT}{a boolean, whether to plot.}

\item{...}{additional arguments going to \code{\link{effect}}}
}
\value{
a model (\code{lm} or \code{glm}).
\itemize{
\item If re_estimate == TRUE, then return will be an re-estimated model with correct marginal impacts given we can find one.
\item If re_estimate == FALSE, original model will be returned.
}
}
\description{
check monotonicity of marginal impacts and re-estimate the model (optional) until we get correct marginal impacts.
}
\details{
This function first calls function \code{\link{effects}}
and then checks the monotonicity of marginal impacts. If the direction of marginal impacts are incorrect,
it can delete a model var that potentially causes the wrong marginal impacts and then re-estimate the model.
We will keep doing this until the correct marginal impacts are found

Details of evaluating the marginal impacts \code{\link{effects}}
}
\examples{

##
set.seed(413)
traing_data = ggplot2::diamonds[runif(nrow(ggplot2::diamonds))<0.05,]
nrow(traing_data)

diamond_lm3 = lm(formula = price ~ carat + I(carat^2) + I(carat^3) + cut +
                   I(carat * depth) , data = traing_data)


test = deleting_wrongeffect(model = diamond_lm3,
                            focus_var_raw = 'carat',
                            focus_var_model = c("I(carat^3)","I(carat*depth)",
                                                "I(carat^2)","I(carat)"),
                            focus_value = list(carat=seq(0.5,6,0.1)),
                            data = traing_data,
                            PRINT = TRUE,STOP = FALSE,
                            Reverse = FALSE)


## two focus on vars
test =
  deleting_wrongeffect(model = diamond_lm3 ,
                       focus_var_raw = c('carat',"cut"),
                       focus_var_model = c("I(carat*depth)","I(carat^3)"),
                       focus_value = list(carat=seq(0.5,6,0.1)),
                       data = traing_data,PRINT = TRUE,STOP =FALSE)

diamond_lm3 = lm(formula = price ~ cut + depth +
                   I(carat * depth) , data = ggplot2::diamonds)
##  negative signs
deleting_wrongeffect(model = diamond_lm3 ,
                     focus_var_raw = c('depth',"cut"),
                     focus_var_model = c("depth"),Monoton_to_Match = -1,
                     data = ggplot2::diamonds,PRINT = TRUE,STOP =FALSE)

## wrong variables names
deleting_wrongeffect(diamond_lm3, focus_var_raw = 'carat',
                     focus_var_model = c("I(cara79t^3)"),
                     data = ggplot2::diamonds,PRINT = TRUE)

deleting_wrongeffect(diamond_lm3, focus_var_raw = 'carat890',
                     focus_var_model = c("I(carat^3)"),
                     data = ggplot2::diamonds, PRINT = TRUE)

}

