% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{forwardQ}
\alias{forwardQ}
\title{models the forward selection event of a fixed number of kernels as a
succession of quadratic constraints}
\usage{
forwardQ(K, select)
}
\arguments{
\item{K}{list kernel similarity matrices}

\item{select}{integer vector containing the indices of the selected kernels}
}
\value{
list of matrices modeling the quadratic constraints of the
selection event
}
\description{
The selection of the kernels with the forward algorithm implemented in
\code{\link{FOHSIC}} can be represented as a set of quadratic constraints.
This is owed to the quadratic form of the HSIC criterion. In this function,
we determine the matrices of the corresponding constraints. The output is a
list of matrices where the order is identical to the order of selection
of the kernels. The matrices are computed such the associated constraint is
nonnegative. For a length \eqn{n} of the list K, the total number of
constraints is \eqn{n - 1}.
}
\examples{
n <- 50
p <- 20
K <- replicate(5, matrix(rnorm(n*p), nrow = n, ncol = p), simplify = FALSE)
K <-  sapply(K, function(X) return(X \%*\% t(X) / dim(X)[2]), simplify = FALSE)
listQ <- forwardQ(K, select = c(4, 1))
}
