% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_percolation.R
\name{graph_match_percolation}
\alias{graph_match_percolation}
\title{Percolation Graph Matching Methods}
\usage{
graph_match_percolation(
  A,
  B,
  seeds,
  similarity = NULL,
  r = 2,
  ExpandWhenStuck = FALSE
)
}
\arguments{
\item{A}{A matrix, igraph object, or list of either.}

\item{B}{A matrix, igraph object, or list of either.}

\item{seeds}{A vector of integers or logicals, a matrix or a data frame. If
the seed pairs have the same indices in both graphs then seeds can be a
vector. If not, seeds must be  a matrix
or a data frame, with the first column being the indices of \eqn{G_1} and
the second column being the corresponding indices of \eqn{G_2}.}

\item{similarity}{A matrix. An \code{n-by-n} matrix containing vertex similarities.}

\item{r}{A number. Threshold of neighboring pair scores.}

\item{ExpandWhenStuck}{A logical. TRUE if expand the seed set when Percolation algorithm
stops before matching all the vertices.}
}
\value{
\code{graph_match_percolation} returns an object of class "\code{\link{graphMatch}}" which is a
  list containing the following components:

  \describe{
    \item{corr_A}{matching correspondence in \eqn{G_1}}
    \item{corr_B}{matching correspondence in \eqn{G_2}}
    \item{match_order}{the order of vertices getting matched}
    \item{seeds}{a vector of logicals indicating if the corresponding vertex is a seed}
  }
}
\description{
Percolation Graph Matching Methods
}
\examples{
# match G_1 & G_2 using percolation graph matching method
cgnp_pair <- sample_correlated_gnp_pair(n = 20, corr =  0.5, p =  0.8)
g1 <- cgnp_pair$graph1
g2 <- cgnp_pair$graph2
seeds <- 1:10 <= 3
GM_perco <- gm(g1, g2, seeds, method = "percolation", r = 2, ExpandWhenStuck = FALSE)
GM_perco

# matching accuracy with the true alignment being the identity
mean(GM_perco$corr_A == GM_perco$corr_B)
GM_perco$match_order

summary(GM_perco, g1, g2, true_label = 1:20)
plot(g1[], g2[], GM_perco)

# expand when stuck
GM_exp <- gm(g1, g2, seeds, method = "percolation", r = 4, ExpandWhenStuck = TRUE)
GM_exp


}
\references{
L. Yartseva and M. Grossglauser (2013), \emph{On the performance
  of percolation graph matching}. COSN, Boston, MA, USA, pages 119–130.

E. Kazemi, S. H. Hassani, and M. Grossglauser (2015),
\emph{Growing a graph matching from a handful of seeds}. Proc. of the VLDB
Endowment, 8(10):1010–1021.
}
\keyword{internal}
